/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.cannon;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.content.schematics.SchematicPrinter;
import com.zurrtum.create.content.schematics.cannon.LaunchedItem;
import com.zurrtum.create.content.schematics.cannon.MaterialChecklist;
import com.zurrtum.create.content.schematics.cannon.SchematicannonInventory;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SchematicannonOptions;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.config.CSchematics;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class SchematicannonBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;
    public SchematicannonInventory inventory;
    public boolean sendUpdate;
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;
    public SchematicPrinter printer;
    public class_1799 missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;
    public class_2338 previousTarget;
    public LinkedHashSet<class_1263> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;
    public int remainingFuel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceBlockEntities;
    public boolean firstRenderTick;
    public float defaultYaw;

    public SchematicannonBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SCHEMATICANNON, pos, state);
        this.setLazyTickRate(30);
        this.attachedInventories = new LinkedHashSet();
        this.flyingBlocks = new LinkedList<LaunchedItem>();
        this.inventory = new SchematicannonInventory(this);
        this.statusMsg = "idle";
        this.state = State.STOPPED;
        this.replaceMode = 2;
        this.checklist = new MaterialChecklist();
        this.printer = new SchematicPrinter();
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.inventory);
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (class_2350 facing : Iterate.directions) {
            class_1263 capability;
            class_2586 blockEntity;
            class_2338 target = this.field_11867.method_10093(facing);
            if (!this.field_11863.method_8477(target)) continue;
            class_2680 state = this.field_11863.method_8320(target);
            if (state.method_27852((class_2248)AllBlocks.CREATIVE_CRATE)) {
                this.hasCreativeCrate = true;
            }
            if ((blockEntity = this.field_11863.method_8321(target)) == null || (capability = ItemHelper.getInventory(this.field_11863, target, state, blockEntity, facing)) == null) continue;
            this.attachedInventories.add(capability);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.read(view);
        }
        this.statusMsg = view.method_71428("Status", "");
        this.schematicProgress = view.method_71423("Progress", 0.0f);
        this.bookPrintingProgress = view.method_71423("PaperProgress", 0.0f);
        this.remainingFuel = view.method_71424("RemainingFuel", 0);
        this.state = view.method_71426("State", State.CODEC).orElse(State.STOPPED);
        this.blocksPlaced = view.method_71424("AmountPlaced", 0);
        this.blocksToPlace = view.method_71424("AmountToPlace", 0);
        this.missingItem = null;
        view.method_71426("MissingItem", class_1799.field_49266).ifPresent(item -> {
            this.missingItem = item;
        });
        view.method_71426("Options", SchematicannonOptions.CODEC).ifPresentOrElse(options -> {
            this.replaceMode = options.replaceMode();
            this.skipMissing = options.skipMissing();
            this.replaceBlockEntities = options.replaceBlockEntities();
        }, () -> {
            this.replaceMode = 2;
            this.skipMissing = false;
            this.replaceBlockEntities = false;
        });
        view.method_71420("Printer").ifPresent(data -> this.printer.read((class_11368)data, clientPacket));
        view.method_71436("FlyingBlocks").ifPresent(this::readFlyingBlocks);
        this.defaultYaw = view.method_71423("DefaultYaw", 0.0f);
        super.read(view, clientPacket);
    }

    protected void readFlyingBlocks(class_11368.class_11370 list) {
        if (list.method_71444()) {
            this.flyingBlocks.clear();
            return;
        }
        boolean pastDead = false;
        int i = -1;
        for (class_11368 item : list) {
            ++i;
            LaunchedItem launched = LaunchedItem.from(item, this.blockHolderGetter());
            class_2338 readBlockPos = launched.target;
            if (this.field_11863 == null || !this.field_11863.field_9236) {
                this.flyingBlocks.add(launched);
                continue;
            }
            while (!(pastDead || this.flyingBlocks.isEmpty() || this.flyingBlocks.getFirst().target.equals((Object)readBlockPos))) {
                this.flyingBlocks.removeFirst();
            }
            pastDead = true;
            if (i < this.flyingBlocks.size()) continue;
            this.flyingBlocks.add(launched);
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.write(view);
            if (this.state == State.RUNNING) {
                view.method_71472("Running", true);
            }
        }
        view.method_71464("Progress", this.schematicProgress);
        view.method_71464("PaperProgress", this.bookPrintingProgress);
        view.method_71465("RemainingFuel", this.remainingFuel);
        view.method_71469("Status", this.statusMsg);
        view.method_71468("State", State.CODEC, (Object)this.state);
        view.method_71465("AmountPlaced", this.blocksPlaced);
        view.method_71465("AmountToPlace", this.blocksToPlace);
        if (this.missingItem != null) {
            view.method_71468("MissingItem", class_1799.field_49266, (Object)this.missingItem);
        }
        view.method_71468("Options", SchematicannonOptions.CODEC, (Object)new SchematicannonOptions(this.replaceMode, this.skipMissing, this.replaceBlockEntities));
        this.printer.write(view.method_71461("Printer"));
        class_11372.class_11374 blocks = view.method_71476("FlyingBlocks");
        for (LaunchedItem b : this.flyingBlocks) {
            b.write(blocks.method_71480());
        }
        view.method_71464("DefaultYaw", this.defaultYaw);
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state != State.STOPPED && this.neighbourCheckCooldown-- <= 0) {
            this.neighbourCheckCooldown = 100;
            this.findInventories();
        }
        this.firstRenderTick = true;
        this.previousTarget = this.printer.getCurrentTarget();
        this.tickFlyingBlocks();
        if (this.field_11863.field_9236) {
            return;
        }
        this.tickPaperPrinter();
        this.refillFuelIfPossible();
        this.skipsLeft = 1000;
        this.blockSkipped = true;
        while (this.blockSkipped && this.skipsLeft-- > 0) {
            this.tickPrinter();
        }
        this.schematicProgress = 0.0f;
        if (this.blocksToPlace > 0) {
            this.schematicProgress = (float)this.blocksPlaced / (float)this.blocksToPlace;
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.server().schematics;
    }

    protected void tickPrinter() {
        ItemRequirement requirement;
        class_1799 blueprint = this.inventory.method_5438(0);
        this.blockSkipped = false;
        if (blueprint.method_7960() && !this.statusMsg.equals("idle") && this.inventory.method_5438(1).method_7960()) {
            this.state = State.STOPPED;
            this.statusMsg = "idle";
            this.sendUpdate = true;
            return;
        }
        if (this.state == State.STOPPED) {
            if (this.printer.isLoaded()) {
                this.resetPrinter();
            }
            return;
        }
        if (this.state == State.PAUSED && !this.positionNotLoaded && this.missingItem == null && this.remainingFuel > 0) {
            return;
        }
        if (!this.printer.isLoaded()) {
            this.initializePrinter(blueprint);
            return;
        }
        if (this.printerCooldown > 0) {
            --this.printerCooldown;
            return;
        }
        if (this.remainingFuel <= 0 && !this.hasCreativeCrate) {
            this.refillFuelIfPossible();
            if (this.remainingFuel <= 0) {
                this.state = State.PAUSED;
                this.statusMsg = "noGunpowder";
                this.sendUpdate = true;
                return;
            }
        }
        if (this.hasCreativeCrate) {
            this.remainingFuel = 0;
            if (this.missingItem != null) {
                this.missingItem = null;
                this.state = State.RUNNING;
            }
        }
        if (this.missingItem == null && !this.positionNotLoaded) {
            if (!this.printer.advanceCurrentPos()) {
                this.finishedPrinting();
                return;
            }
            this.sendUpdate = true;
        }
        if (!this.field_11863.method_8477(this.printer.getCurrentTarget())) {
            this.positionNotLoaded = true;
            this.statusMsg = "targetNotLoaded";
            this.state = State.PAUSED;
            return;
        }
        if (this.positionNotLoaded) {
            this.positionNotLoaded = false;
            this.state = State.RUNNING;
        }
        if ((requirement = this.printer.getCurrentRequirement()).isInvalid() || !this.printer.shouldPlaceCurrent(this.field_11863, this::shouldPlace)) {
            this.sendUpdate = !this.statusMsg.equals("searching");
            this.statusMsg = "searching";
            this.blockSkipped = true;
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            for (ItemRequirement.StackRequirement required : requiredItems) {
                if (this.grabItemsFromAttachedInventories(required, true)) continue;
                if (this.skipMissing) {
                    this.statusMsg = "skipping";
                    this.blockSkipped = true;
                    if (this.missingItem != null) {
                        this.missingItem = null;
                        this.state = State.RUNNING;
                    }
                    return;
                }
                this.missingItem = required.stack;
                this.state = State.PAUSED;
                this.statusMsg = "missingBlock";
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                this.grabItemsFromAttachedInventories(required, false);
            }
        }
        this.state = State.RUNNING;
        class_1799 icon = requirement.isEmpty() || requiredItems.isEmpty() ? class_1799.field_8037 : requiredItems.get((int)0).stack;
        this.printer.handleCurrentTarget((target, blockState, blockEntity) -> {
            this.statusMsg = blockState.method_26204() != class_2246.field_10124 ? "placing" : "clearing";
            this.launchBlockOrBelt(target, icon, blockState, blockEntity);
        }, (target, entity) -> {
            this.statusMsg = "placing";
            this.launchEntity(target, icon, entity);
        });
        this.printerCooldown = (Integer)this.config().schematicannonDelay.get();
        --this.remainingFuel;
        this.sendUpdate = true;
        this.missingItem = null;
    }

    public int getShotsPerGunpowder() {
        return this.hasCreativeCrate ? 0 : (Integer)this.config().schematicannonShotsPerGunpowder.get();
    }

    protected void initializePrinter(class_1799 blueprint) {
        if (!blueprint.method_57826(AllDataComponents.SCHEMATIC_ANCHOR)) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicInvalid";
            this.sendUpdate = true;
            return;
        }
        if (!((Boolean)blueprint.method_58695(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false)).booleanValue()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicNotPlaced";
            this.sendUpdate = true;
            return;
        }
        this.printer.loadSchematic(blueprint, this.field_11863, true);
        if (this.printer.isErrored()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicErrored";
            this.inventory.method_5447(0, class_1799.field_8037);
            this.inventory.method_5447(1, AllItems.EMPTY_SCHEMATIC.method_7854());
            this.printer.resetSchematic();
            this.sendUpdate = true;
            return;
        }
        if (this.printer.isWorldEmpty()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicExpired";
            this.inventory.method_5447(0, class_1799.field_8037);
            this.inventory.method_5447(1, AllItems.EMPTY_SCHEMATIC.method_7854());
            this.printer.resetSchematic();
            this.sendUpdate = true;
            return;
        }
        if (!this.printer.getAnchor().method_19771((class_2382)this.method_11016(), 256.0)) {
            this.state = State.STOPPED;
            this.statusMsg = "targetOutsideRange";
            this.printer.resetSchematic();
            this.sendUpdate = true;
            return;
        }
        this.state = State.PAUSED;
        this.statusMsg = "ready";
        this.updateChecklist();
        this.sendUpdate = true;
        this.blocksToPlace += this.blocksPlaced;
    }

    protected class_1799 getItemForBlock(class_2680 blockState) {
        class_1792 item = blockState.method_26204().method_8389();
        return item == class_1802.field_8162 ? class_1799.field_8037 : item.method_7854();
    }

    protected boolean grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, boolean simulate) {
        boolean success;
        block5: {
            class_1263 cap;
            class_1263 cap2;
            if (this.hasCreativeCrate) {
                return true;
            }
            this.attachedInventories.removeIf(Objects::isNull);
            ItemRequirement.ItemUseType usage = required.usage;
            if (usage == ItemRequirement.ItemUseType.DAMAGE) {
                for (class_1263 cap3 : this.attachedInventories) {
                    if (cap3 == null || !(simulate ? !cap3.count(stack -> required.matches((class_1799)stack) && stack.method_7963(), 1).method_7960() : cap3.update(stack -> required.matches((class_1799)stack) && stack.method_7963(), stack -> {
                        int maxDamage;
                        int damage = stack.method_7919() + 1;
                        if (damage >= (maxDamage = stack.method_7936())) {
                            return class_1799.field_8037;
                        }
                        stack.method_7974(damage);
                        return stack;
                    }))) continue;
                    return true;
                }
                return false;
            }
            int remaining = required.stack.method_7947();
            Iterator cap3 = this.attachedInventories.iterator();
            while (cap3.hasNext() && ((cap2 = (class_1263)cap3.next()) == null || (remaining -= cap2.countAll(required::matches, remaining)) != 0)) {
            }
            boolean bl = success = remaining == 0;
            if (simulate || !success) break block5;
            remaining = required.stack.method_7947();
            Iterator iterator = this.attachedInventories.iterator();
            while (iterator.hasNext() && ((cap = (class_1263)iterator.next()) == null || (remaining -= cap.extractAll(required::matches, remaining)) != 0)) {
            }
        }
        return success;
    }

    public void finishedPrinting() {
        if (this.replaceMode == ConfigureSchematicannonPacket.Option.REPLACE_EMPTY.ordinal()) {
            this.printer.sendBlockUpdates(this.field_11863);
        }
        this.inventory.method_5447(0, class_1799.field_8037);
        this.inventory.method_5447(1, new class_1799((class_1935)AllItems.EMPTY_SCHEMATIC, this.inventory.method_5438(1).method_7947() + 1));
        this.state = State.STOPPED;
        this.statusMsg = "finished";
        this.resetPrinter();
        AllSoundEvents.SCHEMATICANNON_FINISH.playOnServer(this.field_11863, (class_2382)this.field_11867);
        this.sendUpdate = true;
    }

    protected void resetPrinter() {
        this.printer.resetSchematic();
        this.missingItem = null;
        this.sendUpdate = true;
        this.schematicProgress = 0.0f;
        this.blocksPlaced = 0;
        this.blocksToPlace = 0;
    }

    protected boolean shouldPlace(class_2338 pos, class_2680 state, class_2586 be, class_2680 toReplace, class_2680 toReplaceOther, boolean isNormalCube) {
        if (pos.method_19771((class_2382)this.method_11016(), 2.0)) {
            return false;
        }
        if (!this.replaceBlockEntities && (toReplace.method_31709() || toReplaceOther != null && toReplaceOther.method_31709())) {
            return false;
        }
        if (this.shouldIgnoreBlockState(state, be)) {
            return false;
        }
        boolean placingAir = state.method_26215();
        if (this.replaceMode == 3) {
            return true;
        }
        if (this.replaceMode == 2 && !placingAir) {
            return true;
        }
        if (!(this.replaceMode != 1 || !isNormalCube && (toReplace.method_26212((class_1922)this.field_11863, pos) || toReplaceOther != null && toReplaceOther.method_26212((class_1922)this.field_11863, pos)) || placingAir)) {
            return true;
        }
        return this.replaceMode == 0 && !toReplace.method_26212((class_1922)this.field_11863, pos) && (toReplaceOther == null || !toReplaceOther.method_26212((class_1922)this.field_11863, pos)) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(class_2680 state, class_2586 be) {
        if (state.method_26204() == class_2246.field_10369) {
            return true;
        }
        ItemRequirement requirement = ItemRequirement.of(state, be);
        if (requirement.isEmpty()) {
            return false;
        }
        if (requirement.isInvalid()) {
            return false;
        }
        if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
            return true;
        }
        if (state.method_28498((class_2769)class_2741.field_12483) && state.method_11654((class_2769)class_2741.field_12483) == class_2742.field_12560) {
            return true;
        }
        if (state.method_26204() instanceof class_2671) {
            return true;
        }
        if (state.method_27852((class_2248)AllBlocks.BELT)) {
            return state.method_11654(BeltBlock.PART) == BeltPart.MIDDLE;
        }
        return false;
    }

    protected void tickFlyingBlocks() {
        LinkedList<LaunchedItem> toRemove = new LinkedList<LaunchedItem>();
        for (LaunchedItem b : this.flyingBlocks) {
            if (!b.update(this.field_11863)) continue;
            toRemove.add(b);
        }
        this.flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if (this.remainingFuel > this.getShotsPerGunpowder()) {
            this.remainingFuel = this.getShotsPerGunpowder();
            this.sendUpdate = true;
            return;
        }
        if (this.remainingFuel > 0) {
            return;
        }
        class_1799 gunpowder = this.inventory.method_5438(4);
        if (!gunpowder.method_7960()) {
            gunpowder.method_7934(1);
        } else {
            boolean externalGunpowderFound = false;
            for (class_1263 cap : this.attachedInventories) {
                if (cap == null || cap.extractAll(stack -> this.inventory.method_5437(4, (class_1799)stack), 1) == 0) continue;
                externalGunpowderFound = true;
                break;
            }
            if (!externalGunpowderFound) {
                return;
            }
        }
        this.remainingFuel += this.getShotsPerGunpowder();
        if (this.statusMsg.equals("noGunpowder")) {
            if (this.blocksPlaced > 0) {
                this.state = State.RUNNING;
            }
            this.statusMsg = "ready";
        }
        this.sendUpdate = true;
    }

    protected void tickPaperPrinter() {
        boolean outputFull;
        int BookInput = 2;
        int BookOutput = 3;
        class_1799 blueprint = this.inventory.method_5438(0);
        class_1799 paper = this.inventory.method_5438(BookInput);
        class_1799 output = this.inventory.method_5438(BookOutput);
        boolean bl = outputFull = output.method_7947() == output.method_7914();
        if (this.printer.isErrored()) {
            return;
        }
        if (!this.printer.isLoaded()) {
            if (!blueprint.method_7960()) {
                this.initializePrinter(blueprint);
            }
            return;
        }
        if (paper.method_7960() || outputFull) {
            if (this.bookPrintingProgress != 0.0f) {
                this.sendUpdate = true;
            }
            this.bookPrintingProgress = 0.0f;
            this.dontUpdateChecklist = false;
            return;
        }
        if (this.bookPrintingProgress >= 1.0f) {
            this.bookPrintingProgress = 0.0f;
            if (!this.dontUpdateChecklist) {
                this.updateChecklist();
            }
            this.dontUpdateChecklist = true;
            this.inventory.method_5447(BookInput, class_1799.field_8037);
            class_1799 stack = paper.method_31574((class_1792)AllItems.CLIPBOARD) ? this.checklist.createWrittenClipboard() : this.checklist.createWrittenBook();
            stack.method_7939(this.inventory.method_5438(BookOutput).method_7947() + 1);
            this.inventory.method_5447(BookOutput, stack);
            this.inventory.method_5431();
            this.sendUpdate = true;
            return;
        }
        this.bookPrintingProgress += 0.05f;
        this.sendUpdate = true;
    }

    public static class_2680 stripBeltIfNotLast(class_2680 blockState) {
        BeltPart part = (BeltPart)((Object)blockState.method_11654(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return class_2246.field_10124.method_9564();
        }
        boolean isLastSegment = false;
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)blockState.method_11654(BeltBlock.SLOPE));
        boolean positive = facing.method_10171() == class_2350.class_2352.field_11056;
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        switch (slope) {
            case DOWNWARD: {
                isLastSegment = start;
                break;
            }
            case UPWARD: {
                isLastSegment = end;
                break;
            }
            default: {
                boolean bl = isLastSegment = positive && end || !positive && start;
            }
        }
        if (isLastSegment) {
            return blockState;
        }
        return (class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)AbstractSimpleShaftBlock.AXIS, (Comparable)(slope == BeltSlope.SIDEWAYS ? class_2350.class_2351.field_11052 : facing.method_10170().method_10166()));
    }

    /*
     * Unable to fully structure code
     */
    protected void launchBlockOrBelt(class_2338 target, class_1799 icon, class_2680 blockState, class_2586 blockEntity) {
        block4: {
            if (!blockState.method_27852((class_2248)AllBlocks.BELT)) break block4;
            blockState = SchematicannonBlockEntity.stripBeltIfNotLast(blockState);
            if (!(blockEntity instanceof BeltBlockEntity)) ** GOTO lbl-1000
            bbe = (BeltBlockEntity)blockEntity;
            if (blockState.method_27852((class_2248)AllBlocks.BELT)) {
                casings = new BeltBlockEntity.CasingType[bbe.beltLength];
                Arrays.fill((Object[])casings, (Object)BeltBlockEntity.CasingType.NONE);
                currentPos = target;
                for (i = 0; i < bbe.beltLength && (currentState = bbe.method_10997().method_8320(currentPos)).method_26204() instanceof BeltBlock && (var11_12 = bbe.method_10997().method_8321(currentPos)) instanceof BeltBlockEntity; ++i) {
                    beltAtSegment = (BeltBlockEntity)var11_12;
                    casings[i] = beltAtSegment.casing;
                    currentPos = BeltBlock.nextSegmentPosition(currentState, currentPos, blockState.method_11654(BeltBlock.PART) != BeltPart.END);
                }
                this.launchBelt(target, blockState, bbe.beltLength, casings);
            } else if (blockState != class_2246.field_10124.method_9564()) {
                this.launchBlock(target, icon, blockState, null);
            }
            return;
        }
        data = BlockHelper.prepareBlockEntityData(this.field_11863, blockState, blockEntity);
        this.launchBlock(target, icon, blockState, data);
    }

    protected void launchBelt(class_2338 target, class_2680 state, int length, BeltBlockEntity.CasingType[] casings) {
        ++this.blocksPlaced;
        class_1799 connector = AllItems.BELT_CONNECTOR.method_7854();
        this.flyingBlocks.add(new LaunchedItem.ForBelt(this.method_11016(), target, connector, state, casings));
        this.playFiringSound();
    }

    protected void launchBlock(class_2338 target, class_1799 stack, class_2680 state, @Nullable class_2487 data) {
        if (!state.method_26215()) {
            ++this.blocksPlaced;
        }
        this.flyingBlocks.add(new LaunchedItem.ForBlockState(this.method_11016(), target, stack, state, data));
        this.playFiringSound();
    }

    protected void launchEntity(class_2338 target, class_1799 stack, class_1297 entity) {
        ++this.blocksPlaced;
        this.flyingBlocks.add(new LaunchedItem.ForEntity(this.method_11016(), target, stack, entity));
        this.playFiringSound();
    }

    public void playFiringSound() {
        AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.playOnServer(this.field_11863, (class_2382)this.field_11867);
    }

    public SchematicannonMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        this.sendToMenu(extraData);
        return new SchematicannonMenu(id, inv, this);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"create.gui.schematicannon.title");
    }

    public void updateChecklist() {
        this.checklist.required.clear();
        this.checklist.damageRequired.clear();
        this.checklist.blocksNotLoaded = false;
        if (this.printer.isLoaded() && !this.printer.isErrored()) {
            this.blocksToPlace = this.blocksPlaced;
            this.blocksToPlace += this.printer.markAllBlockRequirements(this.checklist, this.field_11863, this::shouldPlace);
            this.printer.markAllEntityRequirements(this.checklist);
        }
        this.checklist.gathered.clear();
        this.findInventories();
        for (class_1263 cap : this.attachedInventories) {
            if (cap == null) continue;
            for (class_1799 stack : cap) {
                this.checklist.collect(stack);
            }
        }
        this.sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    protected void method_57568(class_9473 componentInput) {
        SchematicannonOptions options = (SchematicannonOptions)componentInput.method_58695(AllDataComponents.SCHEMATICANNON_OPTIONS, (Object)new SchematicannonOptions(2, true, false));
        this.replaceMode = options.replaceMode();
        this.skipMissing = options.skipMissing();
        this.replaceBlockEntities = options.replaceBlockEntities();
    }

    protected void method_57567(class_9323.class_9324 components) {
        components.method_57840(AllDataComponents.SCHEMATICANNON_OPTIONS, (Object)new SchematicannonOptions(this.replaceMode, this.skipMissing, this.replaceBlockEntities));
    }

    public static enum State implements class_3542
    {
        STOPPED,
        PAUSED,
        RUNNING;

        public static final Codec<State> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(State::values);
        }
    }
}

