/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphHelper;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class TrainRelocator {
    public static boolean relocate(Train train, class_1937 level, class_2338 pos, BezierTrackPointLocation bezier, boolean bezierDirection, class_243 lookAngle, @Nullable List<class_243> toVisualise) {
        TrackGraphLocation graphLocation;
        class_2680 blockState = level.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        Pair<class_243, class_2350.class_2352> nearestTrackAxis = track.getNearestTrackAxis((class_1922)level, pos, blockState, lookAngle);
        TrackGraphLocation trackGraphLocation = bezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, bezierDirection ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060, bezier) : (graphLocation = TrackGraphHelper.getGraphLocationAt(level, pos, nearestTrackAxis.getSecond(), nearestTrackAxis.getFirst()));
        if (graphLocation == null) {
            return false;
        }
        TrackGraph graph = graphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        TravellingPoint probe = new TravellingPoint(node1, node2, edge, graphLocation.position, false);
        TravellingPoint.IEdgePointListener ignoreSignals = probe.ignoreEdgePoints();
        TravellingPoint.ITurnListener ignoreTurns = probe.ignoreTurns();
        ArrayList recordedLocations = new ArrayList();
        ArrayList recordedVecs = new ArrayList();
        Consumer<TravellingPoint> recorder = tp -> {
            recordedLocations.add(Pair.of(Couple.create(tp.node1, tp.node2), tp.position));
            recordedVecs.add(tp.getPosition(graph));
        };
        TravellingPoint.ITrackSelector steer = probe.steer(TravellingPoint.SteerDirection.NONE, track.getUpNormal((class_1922)level, pos, blockState));
        MutableBoolean blocked = new MutableBoolean(false);
        MutableBoolean portal = new MutableBoolean(false);
        MutableInt blockingIndex = new MutableInt(0);
        train.forEachTravellingPointBackwards((tp, d) -> {
            if (blocked.booleanValue()) {
                return;
            }
            probe.travel(graph, (double)d, steer, ignoreSignals, ignoreTurns, $ -> {
                portal.setTrue();
                return true;
            });
            recorder.accept(probe);
            if (probe.blocked || portal.booleanValue()) {
                blocked.setTrue();
                return;
            }
            blockingIndex.increment();
        });
        if (level.field_9236 && toVisualise != null && !recordedVecs.isEmpty()) {
            toVisualise.clear();
            toVisualise.add((class_243)recordedVecs.getFirst());
        }
        for (int i = 0; i < recordedVecs.size() - 1; ++i) {
            boolean collided;
            class_243 vec1 = (class_243)recordedVecs.get(i);
            class_243 vec2 = (class_243)recordedVecs.get(i + 1);
            boolean blocking = i >= blockingIndex.intValue() - 1;
            boolean bl = collided = !blocked.booleanValue() && train.findCollidingTrain(level, vec1, vec2, (class_5321<class_1937>)level.method_27983()) != null;
            if (level.field_9236 && toVisualise != null) {
                toVisualise.add(vec2);
            }
            if (!collided && !blocking) continue;
            return false;
        }
        if (blocked.booleanValue()) {
            return false;
        }
        if (toVisualise != null) {
            return true;
        }
        train.leaveStation();
        train.derailed = false;
        train.navigation.waitingForSignal = null;
        train.occupiedSignalBlocks.clear();
        train.graph = graph;
        train.speed = 0.0;
        train.migratingPoints.clear();
        train.cancelStall();
        if (train.navigation.destination != null) {
            train.navigation.cancelNavigation();
        }
        train.forEachTravellingPoint(tp -> {
            Pair last = (Pair)recordedLocations.removeLast();
            tp.node1 = (TrackNode)((Couple)last.getFirst()).getFirst();
            tp.node2 = (TrackNode)((Couple)last.getFirst()).getSecond();
            tp.position = (Double)last.getSecond();
            tp.edge = graph.getConnectionsFrom(tp.node1).get(tp.node2);
        });
        for (Carriage carriage : train.carriages) {
            carriage.updateContraptionAnchors();
        }
        train.status.successfulMigration();
        train.collectInitiallyOccupiedSignalBlocks();
        return true;
    }
}

