/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.observer;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.compat.computercraft.events.TrainPassEvent;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.observer.TrackObserverBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class TrackObserverBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public TrackTargetingBehaviour<TrackObserver> edgePoint;
    private ServerFilteringBehaviour filtering;
    public AbstractComputerBehaviour computerBehaviour;
    @Nullable
    public UUID passingTrainUUID;

    public TrackObserverBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK_OBSERVER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<TrackObserver>(this, EdgePointType.OBSERVER);
        behaviours.add(this.edgePoint);
        this.filtering = new ServerFilteringBehaviour(this).withCallback(this::onFilterChanged);
        behaviours.add(this.filtering);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    private void onFilterChanged(class_1799 newFilter) {
        if (this.field_11863.method_8608()) {
            return;
        }
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            observer.setFilterAndNotify(this.field_11863, newFilter);
        }
    }

    @Override
    public void tick() {
        class_2680 blockState;
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        boolean shouldBePowered = false;
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            shouldBePowered = observer.isActivated();
        }
        if (this.isBlockPowered() == shouldBePowered) {
            return;
        }
        if (observer != null && this.computerBehaviour.hasAttachedComputer()) {
            if (shouldBePowered) {
                this.passingTrainUUID = observer.getCurrentTrain();
            }
            if (this.passingTrainUUID != null) {
                this.computerBehaviour.prepareComputerEvent(new TrainPassEvent(Create.RAILWAYS.trains.get(this.passingTrainUUID), shouldBePowered));
                if (!shouldBePowered) {
                    this.passingTrainUUID = null;
                }
            }
        }
        if ((blockState = this.method_11010()).method_28498((class_2769)TrackObserverBlock.POWERED)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)blockState.method_11657((class_2769)TrackObserverBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
        }
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
    }

    @Nullable
    public TrackObserver getObserver() {
        return this.edgePoint.getEdgePoint();
    }

    public class_1799 getFilter() {
        return this.filtering.getFilter();
    }

    public boolean isBlockPowered() {
        return (Boolean)this.method_11010().method_61767((class_2769)TrackObserverBlock.POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(class_243.method_24954((class_2382)this.field_11867), class_243.method_24954((class_2382)this.edgePoint.getGlobalPosition())).method_1014(2.0);
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }
}

