/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.compat.computercraft.events.SignalStateChangeEvent;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.signal.SignalBlock;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public class SignalBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public TrackTargetingBehaviour<SignalBoundary> edgePoint;
    private SignalState state = SignalState.INVALID;
    private OverlayState overlay = OverlayState.SKIP;
    private int switchToRedAfterTrainEntered;
    private boolean lastReportedPower = false;
    public AbstractComputerBehaviour computerBehaviour;

    public SignalBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TRACK_SIGNAL, pos, state);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("State", SignalState.CODEC, (Object)this.state);
        view.method_71468("Overlay", OverlayState.CODEC, (Object)this.overlay);
        view.method_71472("Power", this.lastReportedPower);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.state = view.method_71426("State", SignalState.CODEC).orElse(SignalState.RED);
        this.overlay = view.method_71426("Overlay", OverlayState.CODEC).orElse(OverlayState.RENDER);
        this.lastReportedPower = view.method_71433("Power", false);
        this.invalidateRenderBoundingBox();
    }

    @Nullable
    public SignalBoundary getSignal() {
        return this.edgePoint.getEdgePoint();
    }

    public boolean isPowered() {
        return this.state == SignalState.RED;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<SignalBoundary>(this, EdgePointType.SIGNAL);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        behaviours.add(this.edgePoint);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        SignalBoundary boundary = this.getSignal();
        if (boundary == null) {
            this.enterState(SignalState.INVALID);
            this.setOverlay(OverlayState.RENDER);
            return;
        }
        class_2680 blockState = this.method_11010();
        blockState.method_28500((class_2769)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            boundary.updateBlockEntityPower(this);
            this.notifyUpdate();
        });
        blockState.method_28500(SignalBlock.TYPE).ifPresent(stateType -> {
            SignalBlock.SignalType targetType = boundary.getTypeFor(this.field_11867);
            if (stateType != targetType) {
                this.field_11863.method_8652(this.field_11867, (class_2680)blockState.method_11657(SignalBlock.TYPE, (Comparable)((Object)targetType)), 3);
                this.refreshBlockState();
            }
        });
        this.enterState(boundary.getStateFor(this.field_11867));
        this.setOverlay(boundary.getOverlayFor(this.field_11867));
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public SignalState getState() {
        return this.state;
    }

    public OverlayState getOverlay() {
        return this.overlay;
    }

    public void setOverlay(OverlayState state) {
        if (this.overlay == state) {
            return;
        }
        this.overlay = state;
        this.notifyUpdate();
    }

    public void enterState(SignalState state) {
        if (this.switchToRedAfterTrainEntered > 0) {
            --this.switchToRedAfterTrainEntered;
        }
        if (this.state == state) {
            return;
        }
        if (state == SignalState.RED && this.switchToRedAfterTrainEntered > 0) {
            return;
        }
        this.state = state;
        int n = this.switchToRedAfterTrainEntered = state == SignalState.GREEN || state == SignalState.YELLOW ? 15 : 0;
        if (this.computerBehaviour.hasAttachedComputer()) {
            this.computerBehaviour.prepareComputerEvent(new SignalStateChangeEvent(state));
        }
        this.notifyUpdate();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(class_243.method_24954((class_2382)this.field_11867), class_243.method_24954((class_2382)this.edgePoint.getGlobalPosition())).method_1014(2.0);
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public static enum SignalState implements class_3542
    {
        RED,
        YELLOW,
        GREEN,
        INVALID;

        public static final Codec<SignalState> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isRedLight(float renderTime) {
            return this == RED || this == INVALID && renderTime % 40.0f < 3.0f;
        }

        public boolean isYellowLight(float renderTime) {
            return this == YELLOW;
        }

        public boolean isGreenLight(float renderTime) {
            return this == GREEN;
        }

        static {
            CODEC = class_3542.method_28140(SignalState::values);
        }
    }

    public static enum OverlayState implements class_3542
    {
        RENDER,
        SKIP,
        DUAL;

        public static final Codec<OverlayState> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(OverlayState::values);
        }
    }
}

