/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.filtering;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class ServerSidedFilteringBehaviour
extends ServerFilteringBehaviour {
    Map<class_2350, ServerFilteringBehaviour> sidedFilters;
    private final BiFunction<class_2350, ServerFilteringBehaviour, ServerFilteringBehaviour> filterFactory;
    private final Predicate<class_2350> validDirections;
    private Consumer<class_2350> removeListener;

    public ServerSidedFilteringBehaviour(SmartBlockEntity be, BiFunction<class_2350, ServerFilteringBehaviour, ServerFilteringBehaviour> filterFactory, Predicate<class_2350> validDirections) {
        super(be);
        this.filterFactory = filterFactory;
        this.validDirections = validDirections;
        this.sidedFilters = new IdentityHashMap<class_2350, ServerFilteringBehaviour>();
        this.updateFilterPresence();
    }

    public ServerFilteringBehaviour get(class_2350 side) {
        return this.sidedFilters.get(side);
    }

    public void updateFilterPresence() {
        HashSet<class_2350> valid = new HashSet<class_2350>();
        for (class_2350 d : Iterate.directions) {
            if (!this.validDirections.test(d)) continue;
            valid.add(d);
        }
        for (class_2350 d : Iterate.directions) {
            if (valid.contains(d)) {
                if (this.sidedFilters.containsKey(d)) continue;
                this.sidedFilters.put(d, this.filterFactory.apply(d, new ServerFilteringBehaviour(this.blockEntity)));
                continue;
            }
            if (!this.sidedFilters.containsKey(d)) continue;
            this.removeFilter(d);
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        class_11372.class_11374 list = view.method_71476("Filters");
        this.sidedFilters.forEach((side, filter) -> {
            class_11372 item = list.method_71480();
            item.method_71468("Side", (Codec)class_2350.field_29502, side);
            filter.write(item, clientPacket);
        });
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        view.method_71438("Filters").forEach(item -> {
            class_2350 side = (class_2350)item.method_71426("Side", (Codec)class_2350.field_29502).orElseThrow();
            ServerFilteringBehaviour filter = this.sidedFilters.get(side);
            if (filter != null) {
                filter.read((class_11368)item, clientPacket);
            }
        });
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        this.sidedFilters.values().forEach(BlockEntityBehaviour::tick);
    }

    @Override
    public boolean setFilter(class_2350 side, class_1799 stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        this.sidedFilters.get(side).setFilter(stack);
        return true;
    }

    @Override
    public class_1799 getFilter(class_2350 side) {
        if (!this.sidedFilters.containsKey(side)) {
            return class_1799.field_8037;
        }
        return this.sidedFilters.get(side).getFilter();
    }

    public boolean test(class_2350 side, class_1799 stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        return this.sidedFilters.get(side).test(stack);
    }

    @Override
    public void destroy() {
        this.sidedFilters.values().forEach(ServerFilteringBehaviour::destroy);
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.sidedFilters.values().stream().reduce(ItemRequirement.NONE, (a, b) -> a.union(b.getRequiredItems()), ItemRequirement::union);
    }

    public void removeFilter(class_2350 side) {
        if (!this.sidedFilters.containsKey(side)) {
            return;
        }
        this.sidedFilters.remove(side).destroy();
        if (this.removeListener != null) {
            this.removeListener.accept(side);
        }
    }

    public void setRemoveListener(Consumer<class_2350> removeListener) {
        this.removeListener = removeListener;
    }
}

