/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.item;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3954;

public class InventoryCache
implements Supplier<class_1263> {
    private final BiPredicate<class_2586, class_2350> filter;
    public final class_3218 world;
    public final class_2350 direction;
    public final class_2338 pos;
    public boolean cached;
    public class_1263 inventory;
    public Supplier<class_1263> getter = this::refresh;

    public InventoryCache(class_3218 world, class_2338 pos, class_2350 direction, BiPredicate<class_2586, class_2350> filter) {
        this.world = world;
        this.direction = direction;
        this.pos = pos;
        this.filter = filter;
    }

    @Override
    public class_1263 get() {
        if (this.cached) {
            return this.inventory;
        }
        this.inventory = this.getter.get();
        return this.inventory;
    }

    public void invalidate() {
        this.cached = false;
        this.getter = this::refresh;
    }

    private class_1263 refresh() {
        this.cached = true;
        class_2680 state = this.world.method_8320(this.pos);
        class_2248 block = state.method_26204();
        class_2586 blockEntity = this.world.method_8321(this.pos);
        if (blockEntity != null && this.filter != null && !this.filter.test(blockEntity, this.direction)) {
            return null;
        }
        if (block instanceof ItemInventoryProvider) {
            ItemInventoryProvider provider = (ItemInventoryProvider)block;
            return provider.getInventory(state, (class_1936)this.world, this.pos, blockEntity, this.direction);
        }
        if (block instanceof class_3954) {
            class_3954 provider = (class_3954)block;
            return provider.method_17680(state, (class_1936)this.world, this.pos);
        }
        if (blockEntity instanceof class_1263) {
            class_1263 entityInventory = (class_1263)blockEntity;
            if (blockEntity instanceof class_2595 && block instanceof class_2281) {
                class_2281 chestBlock = (class_2281)block;
                return class_2281.method_17458((class_2281)chestBlock, (class_2680)state, (class_1937)this.world, (class_2338)this.pos, (boolean)true);
            }
            return entityInventory;
        }
        this.getter = AllTransfer.getCacheInventory(this.world, this.pos, this.direction, this.filter);
        if (this.getter == null) {
            return null;
        }
        this.cached = false;
        return this.getter.get();
    }
}

