/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.blueprint;

import com.google.common.cache.Cache;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.api.schematic.requirement.SpecialEntityItemRequirement;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.BlueprintPreviewPacket;
import com.zurrtum.create.infrastructure.packet.s2c.NbtSpawnPacket;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class BlueprintEntity
extends class_1530
implements SpecialEntityItemRequirement,
IInteractionChecker {
    private static final Cache<String, BlueprintPreviewPacket> PREVIEW_CACHE = new TickBasedCache<String, BlueprintPreviewPacket>(20, true);
    private static final class_2940<class_2487> RECIPES = class_2945.method_12791(BlueprintEntity.class, (class_2941)class_2943.field_13318);
    public int size;
    protected class_2350 verticalOrientation;
    private final Map<Integer, BlueprintSection> sectionCache = new HashMap<Integer, BlueprintSection>();

    public BlueprintEntity(class_1299<? extends BlueprintEntity> p_i50221_1_, class_1937 p_i50221_2_) {
        super(p_i50221_1_, p_i50221_2_);
        this.size = 1;
    }

    public BlueprintEntity(class_1937 world, class_2338 pos, class_2350 facing, class_2350 verticalOrientation) {
        super(AllEntityTypes.CRAFTING_BLUEPRINT, world, pos);
        int size = 3;
        while (size > 0) {
            this.size = size--;
            this.updateFacingWithBoundingBox(facing, verticalOrientation);
            if (this.method_6888()) break;
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RECIPES, (Object)new class_2487());
    }

    public void method_5652(class_11372 view) {
        view.method_71468("Orientation", (Codec)class_2350.field_29502, (Object)this.verticalOrientation);
        view.method_71468("Facing", (Codec)class_2350.field_29502, (Object)this.method_5735());
        view.method_71465("Size", this.size);
        view.method_71468("Recipes", class_2487.field_25128, (Object)((class_2487)this.field_6011.method_12789(RECIPES)));
        super.method_5652(view);
    }

    public void method_5749(class_11368 view) {
        this.verticalOrientation = view.method_71426("Orientation", (Codec)class_2350.field_29502).orElse(class_2350.field_11033);
        this.size = view.method_71424("Size", 1);
        view.method_71426("Recipes", class_2487.field_25128).ifPresent(nbt -> this.field_6011.method_12778(RECIPES, nbt));
        super.method_5749(view);
        class_2350 direction = view.method_71426("Facing", (Codec)class_2350.field_29502).orElse(class_2350.field_11033);
        this.updateFacingWithBoundingBox(direction, this.verticalOrientation);
    }

    protected void updateFacingWithBoundingBox(class_2350 facing, class_2350 verticalOrientation) {
        Objects.requireNonNull(facing);
        this.method_71770(facing);
        this.verticalOrientation = verticalOrientation;
        if (facing.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(facing.method_10161() * 90);
        } else {
            this.method_36457(-90 * facing.method_10171().method_10181());
            this.method_36456(verticalOrientation.method_10166().method_10179() ? 180.0f + verticalOrientation.method_10144() : 0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_55685(0.0f);
    }

    protected class_238 method_59943(class_2338 blockPos, class_2350 direction) {
        class_243 pos = class_243.method_24954((class_2382)this.method_59940()).method_1031(0.5, 0.5, 0.5).method_1020(class_243.method_24954((class_2382)direction.method_62675()).method_1021(0.46875));
        double d1 = pos.field_1352;
        double d2 = pos.field_1351;
        double d3 = pos.field_1350;
        this.method_23327(d1, d2, d3);
        class_2350.class_2351 axis = direction.method_10166();
        if (this.size == 2) {
            pos = pos.method_1019(class_243.method_24954((class_2382)(axis.method_10179() ? direction.method_10160().method_62675() : this.verticalOrientation.method_10170().method_62675())).method_1021(0.5)).method_1019(class_243.method_24954((class_2382)(axis.method_10179() ? class_2350.field_11036.method_62675() : (direction == class_2350.field_11036 ? this.verticalOrientation.method_62675() : this.verticalOrientation.method_10153().method_62675()))).method_1021(0.5));
        }
        d1 = pos.field_1352;
        d2 = pos.field_1351;
        d3 = pos.field_1350;
        double d4 = this.getEntityWidth();
        double d5 = this.getEntityHeight();
        double d6 = d4;
        class_2350.class_2351 direction$axis = this.method_5735().method_10166();
        switch (direction$axis) {
            case field_11048: {
                d4 = 1.0;
                break;
            }
            case field_11052: {
                d5 = 1.0;
                break;
            }
            case field_11051: {
                d6 = 1.0;
            }
        }
        return new class_238(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6);
    }

    protected void method_6895() {
        class_2350 direction = this.method_5735();
        if (direction != null && this.verticalOrientation != null) {
            this.method_5857(this.method_59943(this.field_51589, direction));
        }
    }

    public void method_5814(double pX, double pY, double pZ) {
        this.method_23327(pX, pY, pZ);
        super.method_5814(pX, pY, pZ);
    }

    public boolean method_6888() {
        class_1937 world = this.method_37908();
        if (!world.method_17892((class_1297)this)) {
            return false;
        }
        int i = Math.max(1, this.getEntityWidth() / 16);
        int j = Math.max(1, this.getEntityHeight() / 16);
        class_2350 direction = this.method_5735();
        class_2338 blockpos = this.field_51589.method_10093(direction.method_10153());
        class_2350 upDirection = direction.method_10166().method_10179() ? class_2350.field_11036 : (direction == class_2350.field_11036 ? this.verticalOrientation : this.verticalOrientation.method_10153());
        class_2350 newDirection = direction.method_10166().method_10178() ? this.verticalOrientation.method_10170() : direction.method_10160();
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.method_10101((class_2382)blockpos).method_10104(newDirection, k + i1).method_10104(upDirection, l + j1);
                class_2680 blockstate = world.method_8320((class_2338)blockpos$mutable);
                if (class_2248.method_20044((class_4538)world, (class_2338)blockpos$mutable, (class_2350)direction) || blockstate.method_51367() || class_2312.method_9999((class_2680)blockstate)) continue;
                return false;
            }
        }
        return world.method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    public int getEntityWidth() {
        return 16 * this.size;
    }

    public int getEntityHeight() {
        return 16 * this.size;
    }

    public boolean method_5698(class_1297 source) {
        class_1657 player;
        block7: {
            block6: {
                if (!(source instanceof class_1657)) break block6;
                player = (class_1657)source;
                if (!this.method_37908().field_9236) break block7;
            }
            return super.method_5698(source);
        }
        double attrib = player.method_45325(class_5134.field_47758) + (double)(player.method_68878() ? 0.0f : -0.5f);
        class_243 eyePos = source.method_5836(1.0f);
        class_243 look = source.method_5828(1.0f);
        class_243 target = eyePos.method_1019(look.method_1021(attrib));
        Optional rayTrace = this.method_5829().method_992(eyePos, target);
        if (!rayTrace.isPresent()) {
            return super.method_5698(source);
        }
        class_243 hitVec = (class_243)rayTrace.get();
        BlueprintSection sectionAt = this.getSectionAt(hitVec.method_1020(this.method_19538()));
        ItemStackHandler items = sectionAt.getItems();
        if (items.method_5438(9).method_7960()) {
            return super.method_5698(source);
        }
        int size = items.method_5439();
        for (int i = 0; i < size; ++i) {
            items.method_5447(i, class_1799.field_8037);
        }
        sectionAt.save(items);
        return true;
    }

    public void method_6889(class_3218 world, @Nullable class_1297 p_110128_1_) {
        if (!world.method_64395().method_8355(class_1928.field_19393)) {
            return;
        }
        this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
        if (p_110128_1_ instanceof class_1657) {
            class_1657 playerentity = (class_1657)p_110128_1_;
            if (playerentity.method_31549().field_7477) {
                return;
            }
        }
        this.method_5775(world, AllItems.CRAFTING_BLUEPRINT.method_7854());
    }

    @Nullable
    public class_1799 method_31480() {
        return AllItems.CRAFTING_BLUEPRINT.method_7854();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllItems.CRAFTING_BLUEPRINT);
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    public void method_5808(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.method_5814(p_70012_1_, p_70012_3_, p_70012_5_);
    }

    public void method_66246(class_243 pos, float yaw, float pitch) {
        class_2338 blockpos = this.field_51589.method_10081((class_2382)class_2338.method_49637((double)(pos.method_10216() - this.method_23317()), (double)(pos.method_10214() - this.method_23318()), (double)(pos.method_10215() - this.method_23321())));
        this.method_5814(blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260());
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71370(), Create.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.method_56673());
            this.method_5652((class_11372)view);
            NbtSpawnPacket nbtSpawnPacket = new NbtSpawnPacket((class_1297)this, entityTrackerEntry, view.method_71475());
            return nbtSpawnPacket;
        }
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_2487 nbt = ((NbtSpawnPacket)packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71370(), Create.LOGGER);){
            this.method_5749(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)this.method_56673(), (class_2487)nbt));
        }
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (FakePlayerHandler.has((class_1297)player)) {
            return class_1269.field_5811;
        }
        boolean holdingWrench = player.method_5998(hand).method_31574((class_1792)AllItems.WRENCH);
        BlueprintSection section = this.getSectionAt(vec);
        ItemStackHandler items = section.getItems();
        class_1937 world = this.method_37908();
        if (!(holdingWrench || world.field_9236 || items.method_5438(9).method_7960())) {
            class_5455 registryManager = world.method_30349();
            class_1661 playerInv = player.method_31548();
            int size = playerInv.method_5439();
            boolean firstPass = true;
            int amountCrafted = 0;
            class_8786 recipe = null;
            ArrayList<class_1799> results = null;
            do {
                int[] stacksTaken = new int[size];
                int max = 0;
                ArrayList<class_1799> craftingStacks = new ArrayList<class_1799>(9);
                boolean success = true;
                block1: for (int i = 0; i < 9; ++i) {
                    class_1799 filter = items.method_5438(i);
                    if (filter.method_7960()) {
                        craftingStacks.add(class_1799.field_8037);
                        continue;
                    }
                    FilterItemStack requestedItem = FilterItemStack.of(filter);
                    for (int slot = 0; slot < size; ++slot) {
                        class_1799 stack = playerInv.method_5438(slot);
                        if (!requestedItem.test(world, stack)) continue;
                        int used = stacksTaken[slot];
                        if (stack.method_7947() == used) continue;
                        stacksTaken[slot] = used + 1;
                        craftingStacks.add(stack.method_46651(1));
                        if (slot <= max) continue block1;
                        max = slot;
                        continue block1;
                    }
                    success = false;
                    break;
                }
                if (success) {
                    class_9694 input = class_9694.method_59986((int)3, (int)3, craftingStacks);
                    recipe = ((class_3218)world).method_64577().method_59993(class_3956.field_17545, (class_9695)input, world, recipe).orElse(null);
                    if (recipe == null) {
                        success = false;
                    } else {
                        class_3955 craftingRecipe = (class_3955)recipe.comp_1933();
                        class_1799 result = craftingRecipe.method_8116((class_9695)input, (class_7225.class_7874)registryManager);
                        if (result.method_7960() || result.method_7947() + amountCrafted > 64) {
                            success = false;
                        } else {
                            amountCrafted += result.method_7947();
                            result.method_7982(player, 1);
                            results = new ArrayList<class_1799>();
                            results.add(result);
                            for (class_1799 stack : craftingRecipe.method_17704(input)) {
                                if (stack.method_7960()) continue;
                                results.add(stack);
                            }
                            if (firstPass) {
                                world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2f, 1.0f + world.method_8409().method_43057());
                                firstPass = false;
                            }
                        }
                    }
                }
                if (!success) break;
                for (int slot = 0; slot <= max; ++slot) {
                    int used = stacksTaken[slot];
                    if (used == 0) continue;
                    class_1799 stack = playerInv.method_5438(slot);
                    int count = stack.method_7947();
                    if (count == used) {
                        stack = class_1799.field_8037;
                    } else {
                        stack.method_7939(count - used);
                    }
                    playerInv.method_5447(slot, stack);
                }
                playerInv.method_5431();
                for (class_1799 stack : results) {
                    player.method_31548().method_7398(stack);
                }
            } while (player.method_5715());
            PREVIEW_CACHE.invalidate((Object)(this.method_5628() + "_" + section.index + "_" + player.method_5628() + (player.method_5715() ? "_sneaking" : "")));
            return class_1269.field_5812;
        }
        if (!world.field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuProvider.openHandledScreen(serverPlayer, section);
        }
        return class_1269.field_5812;
    }

    public static BlueprintPreviewPacket getPreview(BlueprintEntity be, int index, class_3222 player, boolean sneaking) {
        try {
            return (BlueprintPreviewPacket)PREVIEW_CACHE.get((Object)(be.method_5628() + "_" + index + "_" + player.method_5628() + (sneaking ? "_sneaking" : "")), () -> BlueprintEntity.createPreview(be, index, player, sneaking));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return BlueprintPreviewPacket.EMPTY;
        }
    }

    private static BlueprintPreviewPacket createPreview(BlueprintEntity be, int index, class_3222 player, boolean sneaking) {
        BlueprintSection section = be.getSection(index);
        ItemStackHandler items = section.getItems();
        if (items.method_5442()) {
            return BlueprintPreviewPacket.EMPTY;
        }
        class_3218 world = player.method_51469();
        class_1661 playerInv = player.method_31548();
        int size = playerInv.method_5439();
        int[] stacksTaken = new int[size];
        ArrayList<FilterItemStack> requestedItems = new ArrayList<FilterItemStack>(9);
        ArrayList<class_1799> craftingStacks = new ArrayList<class_1799>(9);
        Object2IntLinkedOpenCustomHashMap<class_1799> missingStacks = BlueprintPreviewPacket.createMap();
        Object2IntLinkedOpenCustomHashMap<class_1799> availableStacks = BlueprintPreviewPacket.createMap();
        block0: for (int i = 0; i < 9; ++i) {
            FilterItemStack requestedItem = FilterItemStack.of(items.method_5438(i));
            if (requestedItem.isEmpty()) {
                requestedItems.add(null);
                craftingStacks.add(class_1799.field_8037);
                continue;
            }
            requestedItems.add(requestedItem);
            for (int slot = 0; slot < size; ++slot) {
                class_1799 stack2 = playerInv.method_5438(slot);
                if (!requestedItem.test((class_1937)world, stack2)) continue;
                int used = stacksTaken[slot];
                if (stack2.method_7947() == used) continue;
                stacksTaken[slot] = used + 1;
                craftingStacks.add(stack2.method_46651(1));
                availableStacks.merge((Object)stack2, 1, Integer::sum);
                continue block0;
            }
            missingStacks.merge((Object)requestedItem.item(), 1, Integer::sum);
        }
        if (!missingStacks.isEmpty()) {
            return new BlueprintPreviewPacket(availableStacks, missingStacks, items.method_5438(9));
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, craftingStacks);
        Optional<class_1799> result = world.method_64577().method_8132(class_3956.field_17545, (class_9695)input, (class_1937)world).map(entry -> ((class_3955)entry.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)world.method_30349())).filter(stack -> !stack.method_7960());
        if (result.isEmpty()) {
            return new BlueprintPreviewPacket(availableStacks, List.of(), class_1799.field_8037);
        }
        class_1799 resultStack = result.get();
        if (sneaking) {
            int max = resultStack.method_7914();
            int craftingCount = resultStack.method_7947();
            if (craftingCount < max) {
                int count = craftingCount;
                Object2IntLinkedOpenCustomHashMap<class_1799> ingredients = BlueprintPreviewPacket.createMap(availableStacks);
                block2: while (count + craftingCount <= max) {
                    block3: for (int i = 0; i < 9; ++i) {
                        FilterItemStack requestedItem = (FilterItemStack)requestedItems.get(i);
                        if (requestedItem == null) continue;
                        for (int slot = 0; slot < size; ++slot) {
                            class_1799 stack3 = playerInv.method_5438(slot);
                            if (!requestedItem.test((class_1937)world, stack3)) continue;
                            int used = stacksTaken[slot];
                            if (stack3.method_7947() == used) continue;
                            stacksTaken[slot] = used + 1;
                            continue block3;
                        }
                        break block2;
                    }
                    ObjectBidirectionalIterator iterator = availableStacks.object2IntEntrySet().fastIterator();
                    do {
                        Object2IntMap.Entry entry2 = (Object2IntMap.Entry)iterator.next();
                        entry2.setValue(entry2.getIntValue() + ingredients.getInt(entry2.getKey()));
                    } while (iterator.hasNext());
                    count += craftingCount;
                }
                resultStack.method_7939(count);
            }
        }
        return new BlueprintPreviewPacket(availableStacks, List.of(), resultStack);
    }

    public BlueprintSection getSectionAt(class_243 vec) {
        int index = 0;
        if (this.size > 1) {
            vec = VecHelper.rotate(vec, this.method_36454(), class_2350.class_2351.field_11052);
            vec = VecHelper.rotate(vec, -this.method_36455(), class_2350.class_2351.field_11048);
            vec = vec.method_1031(0.5, 0.5, 0.0);
            if (this.size == 3) {
                vec = vec.method_1031(1.0, 1.0, 0.0);
            }
            int x = class_3532.method_15340((int)class_3532.method_15357((double)vec.field_1352), (int)0, (int)(this.size - 1));
            int y = class_3532.method_15340((int)class_3532.method_15357((double)vec.field_1351), (int)0, (int)(this.size - 1));
            index = x + y * this.size;
        }
        return this.getSection(index);
    }

    public Optional<class_2487> getRecipeCompound(int index) {
        return ((class_2487)this.field_6011.method_12789(RECIPES)).method_10562(Integer.toString(index));
    }

    public void putRecipeCompound(int index, class_2487 compound) {
        class_2487 recipes = (class_2487)this.field_6011.method_12789(RECIPES);
        recipes.method_10566(Integer.toString(index), (class_2520)compound);
        this.field_6011.method_49743(RECIPES, (Object)recipes, true);
    }

    public BlueprintSection getSection(int index) {
        return this.sectionCache.computeIfAbsent(index, x$0 -> new BlueprintSection((int)x$0));
    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        class_238 box = this.method_5829();
        double dx = 0.0;
        if (box.field_1323 > player.method_23317()) {
            dx = box.field_1323 - player.method_23317();
        } else if (player.method_23317() > box.field_1320) {
            dx = player.method_23317() - box.field_1320;
        }
        double dy = 0.0;
        if (box.field_1322 > player.method_23318()) {
            dy = box.field_1322 - player.method_23318();
        } else if (player.method_23318() > box.field_1325) {
            dy = player.method_23318() - box.field_1325;
        }
        double dz = 0.0;
        if (box.field_1321 > player.method_23321()) {
            dz = box.field_1321 - player.method_23321();
        } else if (player.method_23321() > box.field_1324) {
            dz = player.method_23321() - box.field_1324;
        }
        return dx * dx + dy * dy + dz * dz <= 64.0;
    }

    public class BlueprintSection
    implements MenuProvider,
    IInteractionChecker {
        private static final Couple<class_1799> EMPTY_DISPLAY = Couple.create(class_1799.field_8037, class_1799.field_8037);
        public int index;
        Couple<class_1799> cachedDisplayItems;
        public boolean inferredIcon = false;

        public BlueprintSection(int index) {
            this.index = index;
        }

        public Couple<class_1799> getDisplayItems() {
            if (this.cachedDisplayItems != null) {
                return this.cachedDisplayItems;
            }
            return BlueprintEntity.this.getRecipeCompound(this.index).flatMap(nbt -> nbt.method_67491("Inventory", CreateCodecs.ITEM_LIST_CODEC).map(items -> Couple.create((class_1799)items.get(9), (class_1799)items.get(10)))).orElse(EMPTY_DISPLAY);
        }

        public ItemStackHandler getItems() {
            ItemStackHandler newInv = new ItemStackHandler(11);
            BlueprintEntity.this.getRecipeCompound(this.index).ifPresentOrElse(nbt -> {
                try (class_8942.class_11340 logging = new class_8942.class_11340(BlueprintEntity.this.method_71370(), Create.LOGGER);){
                    class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)BlueprintEntity.this.method_56673(), (class_2487)nbt);
                    newInv.readSlots(view);
                    this.inferredIcon = view.method_71433("InferredIcon", false);
                }
            }, () -> {
                this.inferredIcon = false;
            });
            return newInv;
        }

        public void save(ItemStackHandler inventory) {
            this.cachedDisplayItems = null;
            if (!BlueprintEntity.this.method_37908().field_9236) {
                try (class_8942.class_11340 logging = new class_8942.class_11340(BlueprintEntity.this.method_71370(), Create.LOGGER);){
                    class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)BlueprintEntity.this.method_56673());
                    inventory.writeSlots((class_11372)view);
                    view.method_71472("InferredIcon", this.inferredIcon);
                    BlueprintEntity.this.putRecipeCompound(this.index, view.method_71475());
                }
            }
        }

        public boolean isEntityAlive() {
            return BlueprintEntity.this.method_5805();
        }

        public class_1937 getBlueprintWorld() {
            return BlueprintEntity.this.method_37908();
        }

        public BlueprintMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
            extraData.method_10804(BlueprintEntity.this.method_5628());
            extraData.method_10804(this.index);
            return new BlueprintMenu(id, inv, this);
        }

        @Override
        public class_2561 method_5476() {
            return AllItems.CRAFTING_BLUEPRINT.method_63680();
        }

        @Override
        public boolean canPlayerUse(class_1657 player) {
            return BlueprintEntity.this.canPlayerUse(player);
        }
    }
}

