/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.EjectorItemSpawnPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3231;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class EjectorItemEntity
extends class_1542 {
    private boolean alive;
    public EntityLauncher launcher;
    public class_2350 direction;
    @Nullable
    public Pair<class_243, class_2338> earlyTarget;
    public float earlyTargetTime;
    public int progress;
    public RenderData data;

    public EjectorItemEntity(class_1937 world, EjectorBlockEntity ejector, class_1799 stack) {
        super(AllEntityTypes.EJECTOR_ITEM, world);
        class_2338 pos = ejector.method_11016();
        this.method_5814((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
        this.method_6979(stack);
        if (this.method_37908().field_9236) {
            this.data = new RenderData();
        }
        this.loadLauncher(ejector);
    }

    public EjectorItemEntity(class_1299<? extends EjectorItemEntity> type, class_1937 world) {
        super(type, world);
        if (this.method_37908().field_9236) {
            this.data = new RenderData();
        }
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new EjectorItemSpawnPacket(this, entityTrackerEntry);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        EjectorItemSpawnPacket spawnPacket = (EjectorItemSpawnPacket)packet;
        this.alive = spawnPacket.getAlive();
        this.progress = spawnPacket.getProgress();
        if (!this.alive) {
            class_2586 class_25862 = this.method_37908().method_8321(this.method_24515());
            if (class_25862 instanceof EjectorBlockEntity) {
                EjectorBlockEntity ejector = (EjectorBlockEntity)class_25862;
                this.loadLauncher(ejector);
                return;
            }
            if (spawnPacket.hasLauncher()) {
                this.launcher = spawnPacket.getLauncher();
                this.direction = spawnPacket.getDirection();
                this.data.calcRotate(this.direction.method_10153());
            } else {
                this.alive = true;
            }
        }
    }

    private void loadLauncher(EjectorBlockEntity ejector) {
        this.launcher = ejector.launcher;
        class_2350 facing = ejector.getFacing();
        this.direction = facing.method_10153();
        if (this.method_37908().field_9236) {
            this.data.calcRotate(facing);
        }
    }

    public void method_5652(class_11372 view) {
        view.method_71472("Alive", this.alive);
        view.method_71465("Progress", this.progress);
        if (!this.alive && !(this.method_37908().method_8321(this.method_24515()) instanceof EjectorBlockEntity)) {
            view.method_71468("Launcher", EntityLauncher.CODEC, (Object)this.launcher);
            view.method_71468("Direction", (Codec)class_2350.field_29502, (Object)this.direction);
        }
        super.method_5652(view);
    }

    public void method_5749(class_11368 view) {
        this.alive = view.method_71433("Alive", false);
        this.progress = view.method_71424("Progress", 0);
        if (!this.alive) {
            class_2586 class_25862 = this.method_37908().method_8321(this.method_24515());
            if (class_25862 instanceof EjectorBlockEntity) {
                EjectorBlockEntity ejector = (EjectorBlockEntity)class_25862;
                this.loadLauncher(ejector);
            } else {
                view.method_71426("Launcher", EntityLauncher.CODEC).ifPresentOrElse(this::setLauncher, this::setIsAlive);
                view.method_71426("Direction", (Codec)class_2350.field_29502).ifPresentOrElse(this::setDirection, this::setIsAlive);
                if (!this.alive && this.direction != null && this.method_37908().field_9236) {
                    this.data.calcRotate(this.direction.method_10153());
                }
            }
        }
        super.method_5749(view);
    }

    private void setLauncher(EntityLauncher launcher) {
        this.launcher = launcher;
    }

    private void setDirection(class_2350 direction) {
        this.direction = direction;
    }

    private void setIsAlive() {
        this.alive = true;
    }

    public class_1542 method_29271() {
        class_1542 copy = new class_1542(class_1299.field_6052, this.method_37908());
        copy.method_6979(this.method_6983().method_7972());
        copy.method_5719((class_1297)this);
        copy.field_7204 = this.field_7204;
        copy.field_7203 = this.field_7203;
        return copy;
    }

    public boolean method_5805() {
        return this.alive;
    }

    public void method_5694(class_1657 player) {
        if (this.alive) {
            super.method_5694(player);
        }
    }

    public void method_5773() {
        boolean isClient = this.method_37908().field_9236;
        if (this.alive) {
            if (isClient) {
                this.data.tick();
            }
            super.method_5773();
            return;
        }
        boolean hit = this.scanTrajectoryForObstacles(isClient, this.progress + 1);
        float totalTime = Math.max(3.0f, (float)this.launcher.getTotalFlyingTicks());
        if (hit) {
            this.placeItemAtTarget(isClient, Math.min(this.earlyTargetTime, totalTime));
            return;
        }
        if ((float)(this.progress + 2) >= totalTime) {
            if (isClient) {
                this.data.calcAnimateOffset(totalTime);
            }
            this.placeItemAtTarget(isClient, totalTime);
            return;
        }
        ++this.progress;
    }

    private void placeItemAtTarget(boolean isClient, float maxTime) {
        DirectBeltInputBehaviour targetOpenInv = this.getTargetOpenInv();
        if (targetOpenInv != null) {
            class_1799 remainder = targetOpenInv.handleInsertion(this.method_6983(), class_2350.field_11036, isClient);
            if (remainder.method_7960()) {
                this.method_31472();
                return;
            }
            this.method_6979(remainder);
        }
        this.alive = true;
        class_243 ejectVec = this.earlyTarget != null ? this.earlyTarget.getFirst() : this.getLaunchedItemLocation(maxTime);
        class_243 ejectMotionVec = this.getLaunchedItemMotion(maxTime);
        this.method_5814(ejectVec.field_1352, ejectVec.field_1351, ejectVec.field_1350);
        this.method_63613();
        this.method_18799(ejectMotionVec);
    }

    private DirectBeltInputBehaviour getTargetOpenInv() {
        class_2338 targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.method_24515().method_10086(this.launcher.getVerticalDistance()).method_10079(this.method_58149(), Math.max(1, this.launcher.getHorizontalDistance()));
        return BlockEntityBehaviour.get((class_1922)this.method_37908(), targetPos, DirectBeltInputBehaviour.TYPE);
    }

    private boolean scanTrajectoryForObstacles(boolean isClient, float time) {
        class_2680 blockState;
        class_1937 world;
        class_3965 rayTraceBlocks;
        boolean miss;
        class_243 source = this.getLaunchedItemLocation(time);
        class_243 target = this.getLaunchedItemLocation(time + 1.0f);
        if (isClient) {
            this.data.calcRenderBox(source, target);
        }
        boolean bl = miss = (rayTraceBlocks = (world = this.method_37908()).method_17742(new class_3959(source, target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()))).method_17783() == class_239.class_240.field_1333;
        if (!miss && rayTraceBlocks.method_17783() == class_239.class_240.field_1332 && FunnelBlock.isFunnel(blockState = world.method_8320(rayTraceBlocks.method_17777())) && blockState.method_28498((class_2769)FunnelBlock.EXTRACTING) && ((Boolean)blockState.method_11654((class_2769)FunnelBlock.EXTRACTING)).booleanValue()) {
            miss = true;
        }
        if (miss) {
            if (this.earlyTarget != null && this.earlyTargetTime < time + 1.0f) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        class_243 vec = rayTraceBlocks.method_17784();
        this.earlyTarget = Pair.of(vec.method_1019(class_243.method_24954((class_2382)rayTraceBlocks.method_17780().method_62675()).method_1021(0.25)), rayTraceBlocks.method_17777());
        this.earlyTargetTime = (float)((double)time + source.method_1022(vec) / source.method_1022(target));
        return true;
    }

    public class_243 getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos((double)time, this.direction, this.method_19538());
    }

    public class_243 getLaunchedItemMotion(float time) {
        return this.launcher.getGlobalVelocity(time, this.direction).method_1021(0.5);
    }

    public void method_66246(class_243 pos, float yaw, float pitch) {
    }

    public class RenderData {
        public float rotateY;
        public class_238 renderBox;
        public int initAge;
        public float animateOffset;

        public RenderData() {
            this.renderBox = EjectorItemEntity.this.method_5829();
            this.initAge = -1;
            this.animateOffset = -0.125f;
        }

        public void calcRotate(class_2350 facing) {
            this.rotateY = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        }

        public void calcRenderBox(class_243 source, class_243 target) {
            this.renderBox = new class_238(source.field_1352 - 1.0, source.field_1351 - 1.0, source.field_1350 - 1.0, target.field_1352, target.field_1351, target.field_1350);
        }

        public void calcAnimateOffset(float totalTime) {
            this.animateOffset += (totalTime - (float)EjectorItemEntity.this.progress - 1.0f) / 4.0f;
        }

        public void tick() {
            if (this.initAge == -1) {
                if (EjectorItemEntity.this.method_24828()) {
                    this.initAge = EjectorItemEntity.this.field_6012;
                }
            } else if (this.animateOffset < 0.0f) {
                this.animateOffset = Math.min(this.animateOffset + 0.005f, 0.0f);
            }
        }
    }
}

