/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.burner;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllEntityTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.math.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6010;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class BlazeBurnerBlockItem
extends class_1747 {
    private final boolean capturedBlaze;

    public static BlazeBurnerBlockItem empty(class_1792.class_1793 properties) {
        return new BlazeBurnerBlockItem((class_2248)AllBlocks.BLAZE_BURNER, properties, false);
    }

    public static BlazeBurnerBlockItem withBlaze(class_2248 block, class_1792.class_1793 properties) {
        return new BlazeBurnerBlockItem(block, properties, true);
    }

    public void method_7713(Map<class_2248, class_1792> p_195946_1_, class_1792 p_195946_2_) {
        if (!this.hasCapturedBlaze()) {
            return;
        }
        super.method_7713(p_195946_1_, p_195946_2_);
    }

    private BlazeBurnerBlockItem(class_2248 block, class_1792.class_1793 properties, boolean capturedBlaze) {
        super(block, properties);
        this.capturedBlaze = capturedBlaze;
    }

    public class_1269 method_7884(class_1838 context) {
        if (this.hasCapturedBlaze()) {
            return super.method_7884(context);
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2586 be = world.method_8321(pos);
        class_1657 player = context.method_8036();
        if (!(be instanceof class_2636)) {
            return super.method_7884(context);
        }
        class_2636 mbe = (class_2636)be;
        class_1917 spawner = mbe.method_11390();
        List<class_1952> possibleSpawns = spawner.field_9152.method_34994().stream().map(class_6010::comp_2542).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<class_1952>();
            possibleSpawns.add(spawner.field_9155);
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(mbe.method_71402(), Create.LOGGER);){
            for (class_1952 e : possibleSpawns) {
                class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)e.comp_64());
                Optional optionalEntity = class_1299.method_17684((class_11368)readView);
                if (optionalEntity.isEmpty() || !((class_1299)optionalEntity.get()).method_20210(AllEntityTags.BLAZE_BURNER_CAPTURABLE)) continue;
                this.spawnCaptureEffects(world, VecHelper.getCenterOf((class_2382)pos));
                if (world.field_9236 || player == null) {
                    class_1269.class_9860 class_98602 = class_1269.field_5812;
                    return class_98602;
                }
                this.giveBurnerItemTo(player, context.method_8041(), context.method_20287());
                class_1269.class_9860 class_98603 = class_1269.field_5812;
                return class_98603;
            }
        }
        return super.method_7884(context);
    }

    public class_1269 method_7847(class_1799 heldItem, class_1657 player, class_1309 entity, class_1268 hand) {
        if (this.hasCapturedBlaze()) {
            return class_1269.field_5811;
        }
        if (!entity.method_5864().method_20210(AllEntityTags.BLAZE_BURNER_CAPTURABLE)) {
            return class_1269.field_5811;
        }
        class_1937 world = player.method_37908();
        this.spawnCaptureEffects(world, entity.method_19538());
        if (world.field_9236) {
            return class_1269.field_5814;
        }
        this.giveBurnerItemTo(player, heldItem, hand);
        entity.method_31472();
        return class_1269.field_5814;
    }

    protected void giveBurnerItemTo(class_1657 player, class_1799 heldItem, class_1268 hand) {
        class_1799 filled = AllItems.BLAZE_BURNER.method_7854();
        if (!player.method_68878()) {
            heldItem.method_7934(1);
        }
        if (heldItem.method_7960()) {
            player.method_6122(hand, filled);
            return;
        }
        player.method_31548().method_7398(filled);
    }

    private void spawnCaptureEffects(class_1937 world, class_243 vec) {
        if (world.field_9236) {
            for (int i = 0; i < 40; ++i) {
                class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 0.125f);
                world.method_8406((class_2394)class_2398.field_11240, vec.field_1352, vec.field_1351, vec.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
                class_243 circle = motion.method_18805(1.0, 0.0, 1.0).method_1029().method_1021(0.5);
                world.method_8406((class_2394)class_2398.field_11251, circle.field_1352, vec.field_1351, circle.field_1350, 0.0, -0.125, 0.0);
            }
            return;
        }
        class_2338 soundPos = class_2338.method_49638((class_2374)vec);
        world.method_8396(null, soundPos, class_3417.field_14842, class_3419.field_15251, 0.25f, 0.75f);
        world.method_8396(null, soundPos, class_3417.field_15102, class_3419.field_15251, 0.5f, 0.75f);
    }

    public boolean hasCapturedBlaze() {
        return this.capturedBlaze;
    }
}

