/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ScheduleEntry {
    public static final class_9139<class_9129, ScheduleEntry> STREAM_CODEC = class_9139.method_56435(ScheduleInstruction.STREAM_CODEC, entry -> entry.instruction, CatnipStreamCodecBuilders.list(CatnipStreamCodecBuilders.list(ScheduleWaitCondition.STREAM_CODEC)), entry -> entry.conditions, ScheduleEntry::new);
    public ScheduleInstruction instruction;
    public List<List<ScheduleWaitCondition>> conditions;

    public ScheduleEntry() {
        this.conditions = new ArrayList<List<ScheduleWaitCondition>>();
    }

    public ScheduleEntry(ScheduleInstruction instruction, List<List<ScheduleWaitCondition>> conditions) {
        this.instruction = instruction;
        this.conditions = conditions;
    }

    public ScheduleEntry clone(class_7225.class_7874 registries) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleEntry", Create.LOGGER);){
            class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registries);
            this.write((class_11372)writeView);
            class_11368 readView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registries, (class_2487)writeView.method_71475());
            ScheduleEntry scheduleEntry = ScheduleEntry.read(readView);
            return scheduleEntry;
        }
    }

    public void write(class_11372 view) {
        this.instruction.write(view.method_71461("Instruction"));
        if (!this.instruction.supportsConditions()) {
            return;
        }
        class_11372.class_11374 outer = view.method_71476("Conditions");
        this.conditions.forEach(column -> {
            class_11372.class_11374 list = outer.method_71480().method_71476("Column");
            column.forEach(condition -> condition.write(list.method_71480()));
        });
    }

    public static <T> DataResult<T> encode(ScheduleEntry input, DynamicOps<T> ops, T empty) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Instruction", ScheduleInstruction.encode(input.instruction, ops, empty));
        if (!input.instruction.supportsConditions()) {
            return map.build(empty);
        }
        ListBuilder outer = ops.listBuilder();
        input.conditions.forEach(column -> {
            ListBuilder list = ops.listBuilder();
            column.forEach(condition -> list.add(ScheduleWaitCondition.encode(condition, ops, empty)));
            outer.add(list.build(empty));
        });
        map.add("Conditions", outer.build(empty));
        return map.build(empty);
    }

    public static ScheduleEntry read(class_11368 view) {
        ScheduleEntry entry = new ScheduleEntry();
        entry.instruction = ScheduleInstruction.read(view.method_71434("Instruction"));
        entry.conditions = new ArrayList<List<ScheduleWaitCondition>>();
        if (entry.instruction.supportsConditions()) {
            view.method_71438("Conditions").forEach(column -> entry.conditions.add(column.method_71438("Column").method_71447().map(ScheduleWaitCondition::read).collect(Collectors.toList())));
        }
        return entry;
    }

    public static <T> ScheduleEntry decode(DynamicOps<T> ops, T input) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        ScheduleEntry entry = new ScheduleEntry();
        entry.instruction = ScheduleInstruction.decode(ops, map.get("Instruction"));
        entry.conditions = new ArrayList<List<ScheduleWaitCondition>>();
        if (entry.instruction.supportsConditions()) {
            ((Consumer)ops.getList(map.get("Conditions")).getOrThrow()).accept(column -> entry.conditions.add(((Stream)ops.getStream(column).getOrThrow()).map(item -> ScheduleWaitCondition.decode(ops, item)).collect(Collectors.toList())));
        }
        return entry;
    }
}

