/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class ClipboardEntry {
    public static final Codec<ClipboardEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("checked").forGetter(c -> c.checked), (App)class_8824.field_46597.fieldOf("text").forGetter(c -> c.text), (App)class_1799.field_49266.fieldOf("icon").forGetter(c -> c.icon), (App)Codec.INT.fieldOf("item_amount").forGetter(c -> c.itemAmount)).apply((Applicative)i, (checked, text, icon, itemAmount) -> {
        ClipboardEntry entry = new ClipboardEntry((boolean)checked, text.method_27661());
        if (!icon.method_7960()) {
            entry.displayItem((class_1799)icon, (int)itemAmount);
        }
        return entry;
    }));
    public static final class_9139<class_9129, ClipboardEntry> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, c -> c.checked, (class_9139)class_8824.field_49668, c -> c.text, (class_9139)class_1799.field_49268, c -> c.icon, (class_9139)class_9135.field_49675, c -> c.itemAmount, (checked, text, icon, itemAmount) -> {
        ClipboardEntry entry = new ClipboardEntry((boolean)checked, text.method_27661());
        if (!icon.method_7960()) {
            entry.displayItem((class_1799)icon, (int)itemAmount);
        }
        return entry;
    });
    public boolean checked;
    public class_5250 text;
    public class_1799 icon;
    public int itemAmount;

    public ClipboardEntry(boolean checked, class_5250 text) {
        this.checked = checked;
        this.text = text;
        this.icon = class_1799.field_8037;
    }

    public ClipboardEntry displayItem(class_1799 icon, int amount) {
        this.icon = icon;
        this.itemAmount = amount;
        return this;
    }

    public static List<List<ClipboardEntry>> readAll(class_1799 clipboardItem) {
        return ClipboardEntry.readAll(clipboardItem.method_57353());
    }

    public static List<List<ClipboardEntry>> readAll(class_9323 components) {
        return ClipboardEntry.readAll((ClipboardContent)components.method_58694(AllDataComponents.CLIPBOARD_CONTENT));
    }

    public static List<List<ClipboardEntry>> readAll(@Nullable ClipboardContent content) {
        if (content == null) {
            return new ArrayList<List<ClipboardEntry>>();
        }
        List<List<ClipboardEntry>> saved = content.pages();
        ArrayList<List<ClipboardEntry>> entries = new ArrayList<List<ClipboardEntry>>(saved.size());
        for (List<ClipboardEntry> inner : saved) {
            entries.add(new ArrayList<ClipboardEntry>(inner));
        }
        return entries;
    }

    public static List<ClipboardEntry> getLastViewedEntries(class_1799 heldItem) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(heldItem);
        if (pages.isEmpty()) {
            return new ArrayList<ClipboardEntry>();
        }
        int previouslyOpenedPage = ((ClipboardContent)heldItem.method_58695(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY)).previouslyOpenedPage();
        int page = Math.min(previouslyOpenedPage, pages.size() - 1);
        return pages.get(page);
    }

    public class_2487 writeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("Checked", this.checked);
        nbt.method_67494("Text", class_8824.field_46597, (Object)this.text);
        if (this.icon.method_7960()) {
            return nbt;
        }
        nbt.method_67494("Icon", class_1799.field_24671, (Object)this.icon);
        nbt.method_10569("ItemAmount", this.itemAmount);
        return nbt;
    }

    public static ClipboardEntry readNBT(class_2487 tag) {
        ClipboardEntry clipboardEntry = new ClipboardEntry(tag.method_68566("Checked", false), tag.method_67491("Text", class_8824.field_46597).orElse(class_5244.field_39003).method_27661());
        if (tag.method_10545("Icon")) {
            clipboardEntry.displayItem(tag.method_67491("Icon", class_1799.field_24671).orElse(class_1799.field_8037), tag.method_68083("ItemAmount", 0));
        }
        return clipboardEntry;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClipboardEntry)) {
            return false;
        }
        ClipboardEntry that = (ClipboardEntry)o;
        return this.checked == that.checked && this.text.equals((Object)that.text) && class_1799.method_31577((class_1799)this.icon, (class_1799)that.icon);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.checked);
        result = 31 * result + this.text.hashCode();
        result = 31 * result + class_1799.method_57355((class_1799)this.icon);
        return result;
    }
}

