/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9326;

@Environment(value=EnvType.CLIENT)
public class FluidRenderHelper {
    public static class_4588 getFluidBuilder(class_4597 buffer) {
        return buffer.getBuffer(PonderRenderTypes.fluid());
    }

    public static void renderFluidBox(class_3611 fluid, class_9326 changes, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, class_4597 buffer, class_4587 ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFluidBox(fluid, changes, xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderHelper.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses);
    }

    public static void renderFluidBox(FluidStack stack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, class_4597 buffer, class_4587 ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFluidBox(stack.getFluid(), stack.getComponentChanges(), xMin, yMin, zMin, xMax, yMax, zMax, FluidRenderHelper.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses);
    }

    public static void renderFluidBox(class_3611 fluid, class_9326 changes, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, class_4588 builder, class_4587 ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        class_1058 fluidTexture = config.still().get();
        int color = config.tint().apply(changes) | 0xFF000000;
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
        light = light & 0xF00000 | luminosity << 4;
        class_243 center = new class_243((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.method_22903();
        if (invertGasses) {
            // empty if block
        }
        for (class_2350 side : Iterate.directions) {
            boolean positive;
            if (side == class_2350.field_11033 && !renderBottom) continue;
            boolean bl = positive = side.method_10171() == class_2350.class_2352.field_11056;
            if (side.method_10166().method_10179()) {
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    FluidRenderHelper.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                FluidRenderHelper.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            FluidRenderHelper.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.method_22909();
    }

    public static void renderStillTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587 ms, int light, int color, class_1058 texture) {
        FluidRenderHelper.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587 ms, int light, int color, class_1058 texture, float textureScale) {
        boolean positive = dir.method_10171() == class_2350.class_2352.field_11056;
        boolean horizontal = dir.method_10166().method_10179();
        boolean x = dir.method_10166() == class_2350.class_2351.field_11048;
        float shrink = texture.method_23842() * 0.25f * textureScale;
        float centerU = texture.method_4594() + (texture.method_4577() - texture.method_4594()) * 0.5f * textureScale;
        float centerV = texture.method_4593() + (texture.method_4575() - texture.method_4593()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = class_3532.method_15375((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == class_2350.field_11043 || dir == class_2350.field_11034) {
                f = class_3532.method_15386((float)x2);
                u1 = texture.method_4580((f - x2) * textureScale);
                u2 = texture.method_4580((f - x1) * textureScale);
            } else {
                u1 = texture.method_4580((x1 - f) * textureScale);
                u2 = texture.method_4580((x2 - f) * textureScale);
            }
            u1 = class_3532.method_16439((float)shrink, (float)u1, (float)centerU);
            u2 = class_3532.method_16439((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = class_3532.method_15375((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == class_2350.field_11036) {
                    v1 = texture.method_4570((y1 - f) * textureScale);
                    v2 = texture.method_4570((y2 - f) * textureScale);
                } else {
                    f = class_3532.method_15386((float)y2);
                    v1 = texture.method_4570((f - y2) * textureScale);
                    v2 = texture.method_4570((f - y1) * textureScale);
                }
                v1 = class_3532.method_16439((float)shrink, (float)v1, (float)centerV);
                v2 = class_3532.method_16439((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        FluidRenderHelper.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderHelper.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderHelper.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderHelper.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderHelper.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderHelper.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    protected static void putVertex(class_4588 builder, class_4587 ms, float x, float y, float z, int color, float u, float v, class_2350 face, int light) {
        class_2382 normal = face.method_62675();
        class_4587.class_4665 peek = ms.method_23760();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.method_22918(peek.method_23761(), x, y, z).method_1336(r, g, b, a).method_22913(u, v).method_60803(light).method_60831(peek.method_56822(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260());
    }
}

