/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.glue;

import com.google.common.base.Objects;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.glue.SuperGlueItem;
import com.zurrtum.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.zurrtum.create.infrastructure.packet.c2s.SuperGlueRemovalPacket;
import com.zurrtum.create.infrastructure.packet.c2s.SuperGlueSelectionPacket;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class SuperGlueSelectionHandler {
    private static final int PASSIVE = 5083490;
    private static final int HIGHLIGHT = 6866310;
    private static final int FAIL = 12957000;
    private Object clusterOutlineSlot = new Object();
    private Object bbOutlineSlot = new Object();
    private int clusterCooldown;
    private class_2338 firstPos;
    private class_2338 hoveredPos;
    private Set<class_2338> currentCluster;
    private int glueRequired;
    private SuperGlueEntity selected;
    private class_2338 soundSourceForRemoval;

    public void tick(class_310 mc) {
        class_239 hitResult;
        class_746 player = mc.field_1724;
        class_2338 hovered = null;
        class_1799 stack = player.method_6047();
        if (!this.isGlue(stack)) {
            if (this.firstPos != null) {
                this.discard(player);
            }
            return;
        }
        if (this.clusterCooldown > 0) {
            if (this.clusterCooldown == 25) {
                player.method_7353(class_5244.field_39003, true);
            }
            Outliner.getInstance().keep(this.clusterOutlineSlot);
            --this.clusterCooldown;
        }
        class_238 scanArea = player.method_5829().method_1009(32.0, 16.0, 32.0);
        List glueNearby = mc.field_1687.method_18467(SuperGlueEntity.class, scanArea);
        this.selected = null;
        if (this.firstPos == null) {
            double range = player.method_45325(class_5134.field_47758) + 1.0;
            class_243 traceOrigin = player.method_33571();
            class_243 traceTarget = RaycastHelper.getTraceTarget((class_1657)player, range, traceOrigin);
            double bestDistance = Double.MAX_VALUE;
            for (SuperGlueEntity glueEntity : glueNearby) {
                class_243 vec3;
                double distanceToSqr;
                Optional clip = glueEntity.method_5829().method_992(traceOrigin, traceTarget);
                if (clip.isEmpty() || (distanceToSqr = (vec3 = (class_243)clip.get()).method_1025(traceOrigin)) > bestDistance) continue;
                this.selected = glueEntity;
                this.soundSourceForRemoval = class_2338.method_49638((class_2374)vec3);
                bestDistance = distanceToSqr;
            }
            for (SuperGlueEntity glueEntity : glueNearby) {
                boolean h = this.clusterCooldown == 0 && glueEntity == this.selected;
                AllSpecialTextures faceTex = h ? AllSpecialTextures.GLUE : null;
                Outliner.getInstance().showAABB(glueEntity, glueEntity.method_5829()).colored(h ? 6866310 : 5083490).withFaceTextures(faceTex, faceTex).disableLineNormals().lineWidth(h ? 0.0625f : 0.015625f);
            }
        }
        if ((hitResult = mc.field_1765) != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            hovered = ((class_3965)hitResult).method_17777();
        }
        if (hovered == null) {
            this.hoveredPos = null;
            return;
        }
        if (this.firstPos != null && !this.firstPos.method_19771((class_2382)hovered, 24.0)) {
            CreateLang.translate("super_glue.too_far", new Object[0]).color(12957000).sendStatus((class_1657)player);
            return;
        }
        boolean cancel = player.method_5715();
        if (cancel && this.firstPos == null) {
            return;
        }
        class_238 currentSelectionBox = this.getCurrentSelectionBox();
        boolean unchanged = Objects.equal((Object)hovered, (Object)this.hoveredPos);
        if (unchanged) {
            if (this.currentCluster != null) {
                boolean canReach = this.currentCluster.contains(hovered);
                boolean canAfford = SuperGlueSelectionHelper.collectGlueFromInventory((class_1657)player, this.glueRequired, true);
                int color = 6866310;
                String key = "super_glue.click_to_confirm";
                if (!canReach) {
                    color = 12957000;
                    key = "super_glue.cannot_reach";
                } else if (!canAfford) {
                    color = 12957000;
                    key = "super_glue.not_enough";
                } else if (cancel) {
                    color = 12957000;
                    key = "super_glue.click_to_discard";
                }
                CreateLang.translate(key, new Object[0]).color(color).sendStatus((class_1657)player);
                if (currentSelectionBox != null) {
                    Outliner.getInstance().showAABB(this.bbOutlineSlot, currentSelectionBox).colored(canReach && canAfford && !cancel ? 6866310 : 12957000).withFaceTextures(AllSpecialTextures.GLUE, AllSpecialTextures.GLUE).disableLineNormals().lineWidth(0.0625f);
                }
                Outliner.getInstance().showCluster(this.clusterOutlineSlot, this.currentCluster).colored(5083490).disableLineNormals().lineWidth(0.015625f);
            }
            return;
        }
        this.hoveredPos = hovered;
        Set<class_2338> cluster = SuperGlueSelectionHelper.searchGlueGroup((class_1937)mc.field_1687, this.firstPos, this.hoveredPos, true);
        this.currentCluster = cluster;
        this.glueRequired = 1;
    }

    private boolean isGlue(class_1799 stack) {
        return stack.method_7909() instanceof SuperGlueItem;
    }

    private class_238 getCurrentSelectionBox() {
        return this.firstPos == null || this.hoveredPos == null ? null : new class_238(class_243.method_24954((class_2382)this.firstPos), class_243.method_24954((class_2382)this.hoveredPos)).method_1012(1.0, 1.0, 1.0);
    }

    public boolean onMouseInput(class_310 mc, boolean attack) {
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;
        if (!this.isGlue(player.method_6047())) {
            return false;
        }
        if (!player.method_7294()) {
            return false;
        }
        if (attack) {
            if (this.selected == null) {
                return false;
            }
            player.field_3944.method_52787((class_2596)new SuperGlueRemovalPacket(this.selected.method_5628(), this.soundSourceForRemoval));
            this.selected = null;
            this.clusterCooldown = 0;
            return true;
        }
        if (player.method_5715()) {
            if (this.firstPos != null) {
                this.discard(player);
                return true;
            }
            return false;
        }
        if (this.hoveredPos == null) {
            return false;
        }
        class_2350 face = null;
        class_239 class_2393 = mc.field_1765;
        if (class_2393 instanceof class_3965) {
            AbstractChassisBlock cb;
            class_3965 bhr = (class_3965)class_2393;
            face = bhr.method_17780();
            class_2680 blockState = level.method_8320(this.hoveredPos);
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof AbstractChassisBlock && (cb = (AbstractChassisBlock)class_22482).getGlueableSide(blockState, bhr.method_17780()) != null) {
                return false;
            }
        }
        if (this.firstPos != null && this.currentCluster != null) {
            boolean canReach = this.currentCluster.contains(this.hoveredPos);
            boolean canAfford = SuperGlueSelectionHelper.collectGlueFromInventory((class_1657)player, this.glueRequired, true);
            if (!canReach || !canAfford) {
                return true;
            }
            this.confirm(player);
            return true;
        }
        this.firstPos = this.hoveredPos;
        if (face != null) {
            SuperGlueSelectionHandler.spawnParticles((class_1937)level, this.firstPos, face, true);
        }
        CreateLang.translate("super_glue.first_pos", new Object[0]).sendStatus((class_1657)player);
        AllSoundEvents.SLIME_ADDED.playAt((class_1937)level, (class_2382)this.firstPos, 0.5f, 0.85f, false);
        level.method_8396((class_1297)player, this.firstPos, class_3417.field_14667, class_3419.field_15245, 0.75f, 1.0f);
        return true;
    }

    public void discard(class_746 player) {
        this.currentCluster = null;
        this.firstPos = null;
        CreateLang.translate("super_glue.abort", new Object[0]).sendStatus((class_1657)player);
        this.clusterCooldown = 0;
    }

    public void confirm(class_746 player) {
        player.field_3944.method_52787((class_2596)new SuperGlueSelectionPacket(this.firstPos, this.hoveredPos));
        AllSoundEvents.SLIME_ADDED.playAt((class_1937)player.field_17892, (class_2382)this.hoveredPos, 0.5f, 0.95f, false);
        player.field_17892.method_8396((class_1297)player, this.hoveredPos, class_3417.field_14667, class_3419.field_15245, 0.75f, 1.0f);
        if (this.currentCluster != null) {
            Outliner.getInstance().showCluster(this.clusterOutlineSlot, this.currentCluster).colored(11924166).withFaceTextures(AllSpecialTextures.GLUE, AllSpecialTextures.HIGHLIGHT_CHECKERED).disableLineNormals().lineWidth(0.041666668f);
        }
        this.discard(player);
        CreateLang.translate("super_glue.success", new Object[0]).sendStatus((class_1657)player);
        this.clusterCooldown = 40;
    }

    public static void spawnParticles(class_1937 world, class_2338 pos, class_2350 direction, boolean fullBlock) {
        int i;
        class_243 vec = class_243.method_24954((class_2382)direction.method_62675());
        class_243 plane = VecHelper.axisAlingedPlaneOf(vec);
        class_243 facePos = VecHelper.getCenterOf((class_2382)pos).method_1019(vec.method_1021(0.5));
        float distance = fullBlock ? 1.0f : 0.25f + 0.25f * (world.field_9229.method_43057() - 0.5f);
        plane = plane.method_1021((double)distance);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8777);
        int n = i = fullBlock ? 40 : 15;
        while (i > 0) {
            class_243 offset = VecHelper.rotate(plane, 360.0f * world.field_9229.method_43057(), direction.method_10166());
            class_243 motion = offset.method_1029().method_1021(0.0625);
            if (fullBlock) {
                offset = new class_243(class_3532.method_15350((double)offset.field_1352, (double)-0.5, (double)0.5), class_3532.method_15350((double)offset.field_1351, (double)-0.5, (double)0.5), class_3532.method_15350((double)offset.field_1350, (double)-0.5, (double)0.5));
            }
            class_243 particlePos = facePos.method_1019(offset);
            world.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
            --i;
        }
    }
}

