/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ArmRenderer
extends KineticBlockEntityRenderer<ArmBlockEntity> {
    public ArmRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(ArmBlockEntity be, float pt, class_4587 ms, class_4597 buffer, int light, int overlay) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        boolean rave;
        boolean isBlockItem;
        super.renderSafe(be, pt, ms, buffer, light, overlay);
        class_1799 item = be.heldItem;
        boolean hasItem = !item.method_7960();
        class_1937 world = be.method_10997();
        boolean usingFlywheel = VisualizationManager.supportsVisualization((class_1936)world);
        if (usingFlywheel && !hasItem) {
            return;
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        if (hasItem) {
            itemRenderer.field_55296.method_65598(itemRenderer.field_55297, item, class_811.field_4319, world, null, 0);
            isBlockItem = item.method_7909() instanceof class_1747 ? itemRenderer.field_55297.method_65608() : false;
        } else {
            isBlockItem = false;
        }
        class_4588 builder = buffer.getBuffer(be.goggles ? class_1921.method_23581() : class_1921.method_23577());
        class_2680 blockState = be.method_11010();
        class_4587 msLocal = new class_4587();
        PoseTransformStack msr = TransformStack.of(msLocal);
        boolean inverted = (Boolean)blockState.method_11654((class_2769)ArmBlock.CEILING);
        boolean bl = rave = be.phase == ArmBlockEntity.Phase.DANCING && be.getSpeed() != 0.0f;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((class_1936)world) + (float)(be.hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = class_3532.method_48781((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (int)-45, (int)15);
            upperArmAngle = class_3532.method_48781((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (int)-45, (int)95);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = be.baseAngle.getValue(pt);
            lowerArmAngle = be.lowerArmAngle.getValue(pt) - 135.0f;
            upperArmAngle = be.upperArmAngle.getValue(pt) - 90.0f;
            headAngle = be.headAngle.getValue(pt);
            color = 0xFFFFFF;
        }
        msr.center();
        if (inverted) {
            msr.rotateXDegrees(180.0f);
        }
        if (usingFlywheel) {
            this.doItemTransforms(msr, baseAngle, lowerArmAngle, upperArmAngle, headAngle);
        } else {
            this.renderArm(builder, ms, msLocal, msr, blockState, color, baseAngle, lowerArmAngle, upperArmAngle, headAngle, be.goggles, inverted && be.goggles, hasItem, isBlockItem, light);
        }
        if (hasItem) {
            ms.method_22903();
            float itemScale = isBlockItem ? 0.5f : 0.625f;
            msr.rotateXDegrees(90.0f);
            msLocal.method_46416(0.0f, isBlockItem ? -0.5625f : -0.625f, 0.0f);
            msLocal.method_22905(itemScale, itemScale, itemScale);
            ms.method_23760().method_23761().mul((Matrix4fc)msLocal.method_23760().method_23761());
            itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
            ms.method_22909();
        }
    }

    private void renderArm(class_4588 builder, class_4587 ms, class_4587 msLocal, TransformStack msr, class_2680 blockState, int color, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, boolean goggles, boolean inverted, boolean hasItem, boolean isBlockItem, int light) {
        Object base = CachedBuffers.partial(AllPartialModels.ARM_BASE, blockState).light(light);
        Object lowerBody = CachedBuffers.partial(AllPartialModels.ARM_LOWER_BODY, blockState).light(light);
        Object upperBody = CachedBuffers.partial(AllPartialModels.ARM_UPPER_BODY, blockState).light(light);
        Object claw = CachedBuffers.partial(goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, blockState).light(light);
        Object upperClawGrip = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER, blockState).light(light);
        Object lowerClawGrip = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER, blockState).light(light);
        ArmRenderer.transformBase(msr, baseAngle);
        ((SuperByteBuffer)base.transform(msLocal)).renderInto(ms, builder);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        ((SuperByteBuffer)lowerBody.color(color).transform(msLocal)).renderInto(ms, builder);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        ((SuperByteBuffer)upperBody.color(color).transform(msLocal)).renderInto(ms, builder);
        ArmRenderer.transformHead(msr, headAngle);
        if (inverted) {
            msr.rotateZDegrees(180.0f);
        }
        ((SuperByteBuffer)claw.transform(msLocal)).renderInto(ms, builder);
        if (inverted) {
            msr.rotateZDegrees(180.0f);
        }
        for (int flip : Iterate.positiveAndNegative) {
            msLocal.method_22903();
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            ((SuperByteBuffer)(flip > 0 ? lowerClawGrip : upperClawGrip).transform(msLocal)).renderInto(ms, builder);
            msLocal.method_22909();
        }
    }

    private void doItemTransforms(TransformStack msr, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle) {
        ArmRenderer.transformBase(msr, baseAngle);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        ArmRenderer.transformHead(msr, headAngle);
    }

    public static void transformClawHalf(TransformStack msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)((float)(-flip) * (hasItem ? (isBlockItem ? 0.1875f : 0.078125f) : 0.0625f)), -0.375);
    }

    public static void transformHead(TransformStack msr, float headAngle) {
        msr.translate(0.0, 0.0, -0.9375);
        msr.rotateXDegrees(headAngle - 45.0f);
    }

    public static void transformUpperArm(TransformStack msr, float upperArmAngle) {
        msr.translate(0.0, 0.0, -0.875);
        msr.rotateXDegrees(upperArmAngle - 90.0f);
    }

    public static void transformLowerArm(TransformStack msr, float lowerArmAngle) {
        msr.translate(0.0, 0.125, 0.0);
        msr.rotateXDegrees(lowerArmAngle + 135.0f);
    }

    public static void transformBase(TransformStack msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateYDegrees(baseAngle);
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ArmBlockEntity be, class_2680 state) {
        return CachedBuffers.partial(AllPartialModels.ARM_COG, state);
    }
}

