/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.google.common.base.Objects;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.trains.GlobalRailwayManagerClient;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public class TrackTargetingClient {
    static class_2338 lastHovered;
    static boolean lastDirection;
    static EdgePointType<?> lastType;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static TrackTargetingBlockItem.OverlapResult lastResult;
    static TrackGraphLocation lastLocation;

    public static void clientTick(class_310 mc) {
        class_746 player = mc.field_1724;
        class_243 lookAngle = player.method_5720();
        class_2338 hovered = null;
        boolean direction = false;
        EdgePointType<?> type = null;
        BezierTrackPointLocation hoveredBezier = null;
        class_1799 stack = player.method_6047();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TrackTargetingBlockItem) {
            TrackTargetingBlockItem ttbi = (TrackTargetingBlockItem)class_17922;
            type = ttbi.getType(stack);
        }
        if (type == EdgePointType.SIGNAL) {
            GlobalRailwayManagerClient.tickSignalOverlay(mc);
        }
        boolean alreadySelected = stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        if (type != null) {
            TrackBlockOutline.BezierPointSelection bezierSelection = TrackBlockOutline.result;
            if (alreadySelected) {
                hovered = (class_2338)stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
                direction = (Boolean)stack.method_58695(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)false);
                if (stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER)) {
                    hoveredBezier = (BezierTrackPointLocation)stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
                }
            } else if (bezierSelection != null) {
                hovered = bezierSelection.blockEntity().method_11016();
                hoveredBezier = bezierSelection.loc();
                direction = lookAngle.method_1026(bezierSelection.direction()) < 0.0;
            } else {
                class_3965 blockHitResult;
                class_2338 pos;
                class_2680 blockState;
                class_2248 class_22482;
                class_239 hitResult = mc.field_1765;
                if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332 && (class_22482 = (blockState = mc.field_1687.method_8320(pos = (blockHitResult = (class_3965)hitResult).method_17777())).method_26204()) instanceof ITrackBlock) {
                    ITrackBlock track = (ITrackBlock)class_22482;
                    direction = track.getNearestTrackAxis((class_1922)mc.field_1687, pos, blockState, lookAngle).getSecond() == class_2350.class_2352.field_11056;
                    hovered = pos;
                }
            }
        }
        if (hovered == null) {
            lastHovered = null;
            lastResult = null;
            lastLocation = null;
            lastHoveredBezierSegment = null;
            return;
        }
        if (Objects.equal(hovered, (Object)lastHovered) && Objects.equal(hoveredBezier, (Object)lastHoveredBezierSegment) && direction == lastDirection && type == lastType) {
            return;
        }
        lastType = type;
        lastHovered = hovered;
        lastDirection = direction;
        lastHoveredBezierSegment = hoveredBezier;
        TrackTargetingBlockItem.withGraphLocation((class_1937)mc.field_1687, hovered, direction, hoveredBezier, type, (result, location) -> {
            lastResult = result;
            lastLocation = location;
        });
    }

    public static void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        class_2350.class_2352 direction;
        if (lastLocation == null || TrackTargetingClient.lastResult.feedback != null) {
            return;
        }
        class_2338 pos = lastHovered;
        int light = class_761.method_23794((class_1920)mc.field_1687, (class_2338)pos);
        class_2350.class_2352 class_23522 = direction = lastDirection ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        TrackTargetingBehaviour.RenderedTrackOverlayType type = lastType == EdgePointType.SIGNAL ? TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL : (lastType == EdgePointType.OBSERVER ? TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER : TrackTargetingBehaviour.RenderedTrackOverlayType.STATION);
        class_2680 state = mc.field_1687.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer != null) {
            ms.method_22903();
            TransformStack.of(ms).translate(class_243.method_24954((class_2382)pos).method_1020(camera));
            renderer.render((class_1936)mc.field_1687, state, pos, direction, lastHoveredBezierSegment, ms, buffer, light, class_4608.field_21444, type, 1.0625f);
            ms.method_22909();
        }
    }
}

