/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile.core;

import com.zurrtum.create.client.flywheel.backend.compile.core.ShaderException;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public sealed interface LinkResult {
    public GlProgram unwrap();

    public static LinkResult success(GlProgram program, String log) {
        return new Success(program, log);
    }

    public static LinkResult failure(String failure) {
        return new Failure(failure);
    }

    @Environment(value=EnvType.CLIENT)
    public record Success(GlProgram program, String log) implements LinkResult
    {
        @Override
        @NotNull
        public GlProgram unwrap() {
            return this.program;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Failure(String failure) implements LinkResult
    {
        @Override
        public GlProgram unwrap() {
            throw new ShaderException.Link(this.failure);
        }
    }
}

