/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.backend.gl.GlObject;
import com.zurrtum.create.client.flywheel.lib.memory.FlwMemoryTracker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL45;

@Environment(value=EnvType.CLIENT)
public class ResizableStorageBuffer
extends GlObject {
    private long capacity = 0L;

    public ResizableStorageBuffer() {
        this.handle(GL45.glCreateBuffers());
    }

    public long capacity() {
        return this.capacity;
    }

    public void ensureCapacity(long capacity) {
        FlwMemoryTracker._freeGpuMemory(this.capacity);
        if (this.capacity > 0L) {
            int oldHandle = this.handle();
            int newHandle = GL45.glCreateBuffers();
            GL45.glNamedBufferStorage((int)newHandle, (long)capacity, (int)0);
            GL45.glCopyNamedBufferSubData((int)oldHandle, (int)newHandle, (long)0L, (long)0L, (long)this.capacity);
            this.deleteInternal(oldHandle);
            this.handle(newHandle);
        } else {
            GL45.glNamedBufferStorage((int)this.handle(), (long)capacity, (int)0);
        }
        this.capacity = capacity;
        FlwMemoryTracker._allocGpuMemory(this.capacity);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL15.glDeleteBuffers((int)handle);
    }

    @Override
    public void delete() {
        super.delete();
        FlwMemoryTracker._freeGpuMemory(this.capacity);
    }
}

