/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.util;

import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class AtomicBitSet {
    public static final int DEFAULT_LOG2_SEGMENT_SIZE_IN_BITS = 10;
    private static final long WORD_MASK = -1L;
    private final int numLongsPerSegment;
    private final int log2SegmentSize;
    private final int segmentMask;
    private final AtomicReference<AtomicBitSetSegments> segments;

    public AtomicBitSet() {
        this(10);
    }

    public AtomicBitSet(int log2SegmentSizeInBits) {
        this(log2SegmentSizeInBits, 0);
    }

    public AtomicBitSet(int log2SegmentSizeInBits, int numBitsToPreallocate) {
        if (log2SegmentSizeInBits < 6) {
            throw new IllegalArgumentException("Cannot specify fewer than 64 bits in each segment!");
        }
        this.log2SegmentSize = log2SegmentSizeInBits;
        this.numLongsPerSegment = 1 << log2SegmentSizeInBits - 6;
        this.segmentMask = this.numLongsPerSegment - 1;
        long numBitsPerSegment = (long)this.numLongsPerSegment * 64L;
        int numSegmentsToPreallocate = numBitsToPreallocate == 0 ? 1 : (int)((long)(numBitsToPreallocate - 1) / numBitsPerSegment + 1L);
        this.segments = new AtomicReference<AtomicBitSetSegments>(new AtomicBitSetSegments(numSegmentsToPreallocate, this.numLongsPerSegment));
    }

    public void set(int position, boolean value) {
        if (value) {
            this.set(position);
        } else {
            this.clear(position);
        }
    }

    public void set(int position) {
        int longPosition = this.longIndexInSegmentForPosition(position);
        AtomicLongArray segment = this.getSegmentForPosition(position);
        this.setOr(segment, longPosition, AtomicBitSet.maskForPosition(position));
    }

    public void clear(int position) {
        int longPosition = this.longIndexInSegmentForPosition(position);
        AtomicLongArray segment = this.getSegmentForPosition(position);
        this.setAnd(segment, longPosition, AtomicBitSet.maskForPosition(position) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void set(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int firstSegmentIndex = this.segmentIndexForPosition(fromIndex);
        int toSegmentIndex = this.segmentIndexForPosition(toIndex);
        AtomicBitSetSegments segments = this.expandToFit(toSegmentIndex);
        int fromLongIndex = this.longIndexInSegmentForPosition(fromIndex);
        int toLongIndex = this.longIndexInSegmentForPosition(toIndex);
        long fromLongMask = -1L << fromIndex;
        long toLongMask = -1L >>> -toIndex;
        AtomicLongArray segment = segments.getSegment(firstSegmentIndex);
        if (firstSegmentIndex == toSegmentIndex) {
            if (fromLongIndex == toLongIndex) {
                this.setOr(segment, fromLongIndex, fromLongMask & toLongMask);
            } else {
                this.setOr(segment, fromLongIndex, fromLongMask);
                for (int i = fromLongIndex + 1; i < toLongIndex; ++i) {
                    segment.set(i, -1L);
                }
                this.setOr(segment, toLongIndex, toLongMask);
            }
        } else {
            int i;
            this.setOr(segment, fromLongIndex, fromLongMask);
            for (i = fromLongIndex + 1; i < this.numLongsPerSegment; ++i) {
                segment.set(i, -1L);
            }
            for (i = firstSegmentIndex + 1; i < toSegmentIndex; ++i) {
                segment = segments.getSegment(i);
                for (int j = 0; j < segment.length(); ++j) {
                    segment.set(j, -1L);
                }
            }
            segment = segments.getSegment(toSegmentIndex);
            for (i = 0; i < toLongIndex; ++i) {
                segment.set(i, -1L);
            }
            this.setOr(segment, toLongIndex, toLongMask);
        }
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        AtomicBitSetSegments segments = this.segments.get();
        int numSegments = segments.numSegments();
        int firstSegmentIndex = this.segmentIndexForPosition(fromIndex);
        if (firstSegmentIndex >= numSegments) {
            return;
        }
        int toSegmentIndex = this.segmentIndexForPosition(toIndex);
        if (toSegmentIndex >= numSegments) {
            toSegmentIndex = numSegments - 1;
        }
        int fromLongIndex = this.longIndexInSegmentForPosition(fromIndex);
        int toLongIndex = this.longIndexInSegmentForPosition(toIndex);
        long fromLongMask = -1L << fromIndex;
        long toLongMask = -1L >>> -toIndex;
        AtomicLongArray segment = segments.getSegment(firstSegmentIndex);
        if (firstSegmentIndex == toSegmentIndex) {
            if (fromLongIndex == toLongIndex) {
                this.setAnd(segment, fromLongIndex, fromLongMask & toLongMask ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.setAnd(segment, fromLongIndex, fromLongMask ^ 0xFFFFFFFFFFFFFFFFL);
                for (int i = fromLongIndex + 1; i < toLongIndex; ++i) {
                    segment.set(i, 0L);
                }
                this.setAnd(segment, toLongIndex, toLongMask ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            int i;
            this.setAnd(segment, fromLongIndex, fromLongMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (i = fromLongIndex + 1; i < this.numLongsPerSegment; ++i) {
                segment.set(i, 0L);
            }
            for (i = firstSegmentIndex + 1; i < toSegmentIndex; ++i) {
                segment = segments.getSegment(i);
                for (int j = 0; j < segment.length(); ++j) {
                    segment.set(j, 0L);
                }
            }
            segment = segments.getSegment(toSegmentIndex);
            for (i = 0; i < toLongIndex; ++i) {
                segment.set(i, 0L);
            }
            this.setAnd(segment, toLongIndex, toLongMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private void setOr(AtomicLongArray segment, int indexInSegment, long mask) {
        long newLongValue;
        long currentLongValue;
        while (!segment.compareAndSet(indexInSegment, currentLongValue = segment.get(indexInSegment), newLongValue = currentLongValue | mask)) {
        }
    }

    private void setAnd(AtomicLongArray segment, int indexInSegment, long mask) {
        long newLongValue;
        long currentLongValue;
        while (!segment.compareAndSet(indexInSegment, currentLongValue = segment.get(indexInSegment), newLongValue = currentLongValue & mask)) {
        }
    }

    public boolean get(int position) {
        int segmentPosition = this.segmentIndexForPosition(position);
        int longPosition = this.longIndexInSegmentForPosition(position);
        AtomicLongArray segment = this.segmentForPosition(segmentPosition);
        long mask = AtomicBitSet.maskForPosition(position);
        return (segment.get(longPosition) & mask) != 0L;
    }

    public long maxSetBit() {
        AtomicBitSetSegments segments = this.segments.get();
        for (int segmentIdx = segments.numSegments() - 1; segmentIdx >= 0; --segmentIdx) {
            AtomicLongArray segment = segments.getSegment(segmentIdx);
            for (int longIdx = segment.length() - 1; longIdx >= 0; --longIdx) {
                long l = segment.get(longIdx);
                if (l == 0L) continue;
                return ((long)segmentIdx << this.log2SegmentSize) + (long)longIdx * 64L + (long)(63 - Long.numberOfLeadingZeros(l));
            }
        }
        return -1L;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        AtomicBitSetSegments segments = this.segments.get();
        int segmentPosition = this.segmentIndexForPosition(fromIndex);
        if (segmentPosition >= segments.numSegments()) {
            return -1;
        }
        int longPosition = this.longIndexInSegmentForPosition(fromIndex);
        AtomicLongArray segment = segments.getSegment(segmentPosition);
        long word = segment.get(longPosition) & -1L << AtomicBitSet.bitPosInLongForPosition(fromIndex);
        while (word == 0L) {
            if (++longPosition > this.segmentMask) {
                if (++segmentPosition >= segments.numSegments()) {
                    return -1;
                }
                segment = segments.getSegment(segmentPosition);
                longPosition = 0;
            }
            word = segment.get(longPosition);
        }
        return (segmentPosition << this.log2SegmentSize) + (longPosition << 6) + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        AtomicBitSetSegments segments;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int segmentPosition = this.segmentIndexForPosition(fromIndex);
        if (segmentPosition >= (segments = this.segments.get()).numSegments()) {
            return fromIndex;
        }
        int longPosition = this.longIndexInSegmentForPosition(fromIndex);
        AtomicLongArray segment = segments.getSegment(segmentPosition);
        long word = (segment.get(longPosition) ^ 0xFFFFFFFFFFFFFFFFL) & -1L << AtomicBitSet.bitPosInLongForPosition(fromIndex);
        while (word == 0L) {
            if (++longPosition > this.segmentMask) {
                if (++segmentPosition >= segments.numSegments()) {
                    return segments.numSegments() << this.log2SegmentSize + (longPosition << 6);
                }
                segment = segments.getSegment(segmentPosition);
                longPosition = 0;
            }
            word = segment.get(longPosition) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (segmentPosition << this.log2SegmentSize) + (longPosition << 6) + Long.numberOfTrailingZeros(word);
    }

    public int cardinality() {
        return this.segments.get().cardinality();
    }

    public void forEachSetSpan(BitSpanConsumer consumer) {
        AtomicBitSetSegments segments = this.segments.get();
        if (segments.cardinality() == 0) {
            return;
        }
        int start = -1;
        int end = -1;
        for (int segmentIndex = 0; segmentIndex < segments.numSegments(); ++segmentIndex) {
            AtomicLongArray segment = segments.getSegment(segmentIndex);
            for (int longIndex = 0; longIndex < segment.length(); ++longIndex) {
                long l = segment.get(longIndex);
                if (l != 0L) {
                    for (int bitIndex = 0; bitIndex < 64; ++bitIndex) {
                        if ((l & 1L << bitIndex) != 0L) {
                            int position = (segmentIndex << this.log2SegmentSize) + (longIndex << 6) + bitIndex;
                            if (start == -1) {
                                start = position;
                            }
                            end = position;
                            continue;
                        }
                        if (start == -1) continue;
                        consumer.accept(start, end);
                        start = -1;
                        end = -1;
                    }
                    continue;
                }
                if (start == -1) continue;
                consumer.accept(start, end);
                start = -1;
                end = -1;
            }
        }
        if (start != -1) {
            consumer.accept(start, end);
        }
    }

    public int currentCapacity() {
        return this.segments.get().numSegments() * (1 << this.log2SegmentSize);
    }

    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    public void clear() {
        AtomicBitSetSegments segments = this.segments.get();
        for (int i = 0; i < segments.numSegments(); ++i) {
            AtomicLongArray segment = segments.getSegment(i);
            for (int j = 0; j < segment.length(); ++j) {
                segment.set(j, 0L);
            }
        }
    }

    private static int bitPosInLongForPosition(int position) {
        return position & 0x3F;
    }

    private int longIndexInSegmentForPosition(int position) {
        return position >>> 6 & this.segmentMask;
    }

    private int segmentIndexForPosition(int position) {
        return position >>> this.log2SegmentSize;
    }

    private static long maskForPosition(int position) {
        return 1L << AtomicBitSet.bitPosInLongForPosition(position);
    }

    private AtomicLongArray getSegmentForPosition(int position) {
        return this.segmentForPosition(this.segmentIndexForPosition(position));
    }

    private AtomicLongArray segmentForPosition(int segmentIndex) {
        return this.expandToFit(segmentIndex).getSegment(segmentIndex);
    }

    @NotNull
    private AtomicBitSetSegments expandToFit(int segmentIndex) {
        AtomicBitSetSegments visibleSegments = this.segments.get();
        while (visibleSegments.numSegments() <= segmentIndex) {
            AtomicBitSetSegments newVisibleSegments = new AtomicBitSetSegments(visibleSegments, segmentIndex + 1, this.numLongsPerSegment);
            if (this.segments.compareAndSet(visibleSegments, newVisibleSegments)) {
                visibleSegments = newVisibleSegments;
                continue;
            }
            visibleSegments = this.segments.get();
        }
        return visibleSegments;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof AtomicBitSet)) {
            return false;
        }
        AtomicBitSet other = (AtomicBitSet)obj;
        if (other.log2SegmentSize != this.log2SegmentSize) {
            throw new IllegalArgumentException("Segment sizes must be the same");
        }
        AtomicBitSetSegments thisSegments = this.segments.get();
        AtomicBitSetSegments otherSegments = other.segments.get();
        for (i = 0; i < thisSegments.numSegments(); ++i) {
            AtomicLongArray thisArray = thisSegments.getSegment(i);
            AtomicLongArray otherArray = i < otherSegments.numSegments() ? otherSegments.getSegment(i) : null;
            for (int j = 0; j < thisArray.length(); ++j) {
                long otherLong;
                long thisLong = thisArray.get(j);
                long l = otherLong = otherArray == null ? 0L : otherArray.get(j);
                if (thisLong == otherLong) continue;
                return false;
            }
        }
        for (i = thisSegments.numSegments(); i < otherSegments.numSegments(); ++i) {
            AtomicLongArray otherArray = otherSegments.getSegment(i);
            for (int j = 0; j < otherArray.length(); ++j) {
                long l = otherArray.get(j);
                if (l == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.log2SegmentSize;
        result = 31 * result + Arrays.hashCode(this.segments.get().segments);
        return result;
    }

    public BitSet toBitSet() {
        BitSet resultSet = new BitSet();
        int ordinal = this.nextSetBit(0);
        while (ordinal != -1) {
            resultSet.set(ordinal);
            ordinal = this.nextSetBit(ordinal + 1);
        }
        return resultSet;
    }

    public String toString() {
        return this.toBitSet().toString();
    }

    @Environment(value=EnvType.CLIENT)
    private static class AtomicBitSetSegments {
        private final AtomicLongArray[] segments;

        private AtomicBitSetSegments(int numSegments, int segmentLength) {
            AtomicLongArray[] segments = new AtomicLongArray[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                segments[i] = new AtomicLongArray(segmentLength);
            }
            this.segments = segments;
        }

        private AtomicBitSetSegments(AtomicBitSetSegments copyFrom, int numSegments, int segmentLength) {
            AtomicLongArray[] segments = new AtomicLongArray[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                segments[i] = i < copyFrom.numSegments() ? copyFrom.getSegment(i) : new AtomicLongArray(segmentLength);
            }
            this.segments = segments;
        }

        private int cardinality() {
            int numSetBits = 0;
            for (int i = 0; i < this.numSegments(); ++i) {
                AtomicLongArray segment = this.getSegment(i);
                for (int j = 0; j < segment.length(); ++j) {
                    numSetBits += Long.bitCount(segment.get(j));
                }
            }
            return numSetBits;
        }

        public int numSegments() {
            return this.segments.length;
        }

        public AtomicLongArray getSegment(int index) {
            return this.segments[index];
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BitSpanConsumer {
        public void accept(int var1, int var2);
    }
}

