/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.ui;

import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.catnip.layout.LayoutHelper;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.foundation.PonderChapter;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.ui.AbstractPonderScreen;
import com.zurrtum.create.client.ponder.foundation.ui.PonderButton;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class PonderTagScreen
extends AbstractPonderScreen {
    private final PonderTag tag;
    protected final List<ItemEntry> items = new ArrayList<ItemEntry>();
    private final double itemXmult = 0.5;
    @Nullable
    protected class_768 itemArea;
    protected final List<PonderChapter> chapters = new ArrayList<PonderChapter>();
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    @Nullable
    protected class_768 chapterArea;
    private final double mainYmult = 0.15;
    private class_1799 hoveredItem = class_1799.field_8037;

    public PonderTagScreen(class_2960 tag) {
        this.tag = PonderIndex.getTagAccess().getRegisteredTag(tag);
    }

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.items.clear();
        PonderIndex.getTagAccess().getItems(this.tag).stream().map(key -> new ItemEntry(RegisteredObjectsHelper.getItemOrBlock(key), (class_2960)key)).filter(entry -> entry.item != null).forEach(this.items::add);
        if (!this.tag.getMainItem().method_7960()) {
            this.items.removeIf(entry -> entry.item == this.tag.getMainItem().method_7909());
        }
        int rowCount = class_3532.method_15340((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.field_22789 * 0.5);
        int itemCenterY = this.getItemsY();
        for (ItemEntry entry2 : this.items) {
            Object b = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new class_1799(entry2.item));
            if (PonderIndex.getSceneAccess().doScenesExistForId(entry2.key)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(new class_1799(entry.item), this.tag));
                });
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(entry2.key.method_12836().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)).animateColors(false);
            }
            this.method_37063((class_364)b);
            layout.next();
        }
        if (!this.tag.getMainItem().method_7960()) {
            class_2960 registryName = RegisteredObjectsHelper.getKeyOrThrow(this.tag.getMainItem().method_7909());
            Object b = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 48, itemCenterY - 10).showing(this.tag.getMainItem());
            if (PonderIndex.getSceneAccess().doScenesExistForId(registryName)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
                });
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(registryName.method_12836().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)).animateColors(false);
            }
            this.method_37063((class_364)b);
        }
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(this.tag);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++PonderUI.ponderTicks;
        this.hoveredItem = class_1799.field_8037;
        class_1041 w = this.field_22787.method_22683();
        int mX = (int)(this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480());
        int mY = (int)(this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507());
        for (class_364 child : this.method_25396()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).method_25405(mX, mY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        this.renderItems(graphics, mouseX, mouseY, partialTicks);
        this.renderChapters(graphics, mouseX, mouseY, partialTicks);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)(this.field_22789 / 2 - 120), (float)((double)this.field_22790 * 0.15 - 40.0));
        poseStack.pushMatrix();
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(graphics, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(21.0f, 21.0f, 100.0f).withBounds(30, 30).render(graphics);
        graphics.method_51439(this.field_22793, (class_2561)Ponder.lang().translate("ui.pondering", new Object[0]).component(), x, y - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB(), false);
        poseStack.translate((float)(x += 0), (float)(y += 8));
        graphics.method_51433(this.field_22793, title, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        poseStack.translate(23.0f, 23.0f);
        poseStack.scale(1.66f, 1.66f);
        this.tag.render(graphics, 0, 0);
        poseStack.popMatrix();
        poseStack.popMatrix();
        poseStack.pushMatrix();
        int w = (int)((double)this.field_22789 * 0.45);
        x = (this.field_22789 - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.method_3320(), 48);
        String desc = this.tag.getDescription();
        int h = this.field_22793.method_1713(desc, w);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(x - 3, y - 3, 90.0f).withBounds(w + 6, h + 6).render(graphics);
        ClientFontHelper.drawSplitString(graphics, this.field_22793, desc, x, y, w, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.popMatrix();
    }

    protected void renderItems(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.field_22789 * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Ponder.lang().translate("ui.associated", new Object[0]).string();
        int stringWidth = this.field_22793.method_1727(relatedTitle);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.method_3322() - 21, 100.0f).withBounds(stringWidth + 10, 10).render(graphics);
        graphics.method_25300(this.field_22793, relatedTitle, this.windowWidth / 2, this.itemArea.method_3322() - 20, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        UIRenderHelper.streak(graphics, 0.0f, 0, 0, this.itemArea.method_3320() + 10, this.itemArea.method_3319() / 2 + 75);
        UIRenderHelper.streak(graphics, 180.0f, 0, 0, this.itemArea.method_3320() + 10, this.itemArea.method_3319() / 2 + 75);
        poseStack.popMatrix();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.field_22790 + 85.0);
    }

    protected void renderChapters(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.field_22789 * 0.5);
        int chapterY = (int)((double)this.field_22790 * 0.75);
        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)chapterX, (float)chapterY);
        UIRenderHelper.streak(graphics, 0.0f, this.chapterArea.method_3321() - 10, this.chapterArea.method_3322() - 20, 20, 220);
        graphics.method_51433(this.field_22793, "More Topics to Ponder about", this.chapterArea.method_3321() - 5, this.chapterArea.method_3322() - 25, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
        matrices.popMatrix();
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.hoveredItem.method_7960()) {
            graphics.method_51446(this.field_22793, this.hoveredItem, mouseX, mouseY);
        }
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    @Override
    public void method_25432() {
        super.method_25432();
        this.hoveredItem = class_1799.field_8037;
        for (class_4068 drawable : this.field_33816) {
            if (!(drawable instanceof ElementWidget)) continue;
            ElementWidget widget = (ElementWidget)drawable;
            widget.getRenderElement().clear();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record ItemEntry(@Nullable class_1935 item, class_2960 key) {
    }
}

