/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.config;

import com.zurrtum.create.client.flywheel.lib.visualization.SimpleEntityVisualizer;
import com.zurrtum.create.client.vanillin.config.Configurator;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class EntityVisualizerBuilder<T extends class_1297> {
    private final Configurator configurator;
    private final class_1299<T> type;
    @Nullable
    private SimpleEntityVisualizer.Factory<T> visualFactory;
    @Nullable
    private Predicate<T> skipVanillaRender;

    public EntityVisualizerBuilder(Configurator configurator, class_1299<T> type) {
        this.configurator = configurator;
        this.type = type;
    }

    public EntityVisualizerBuilder<T> factory(SimpleEntityVisualizer.Factory<T> visualFactory) {
        this.visualFactory = visualFactory;
        return this;
    }

    public EntityVisualizerBuilder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
        this.skipVanillaRender = skipVanillaRender;
        return this;
    }

    public EntityVisualizerBuilder<T> neverSkipVanillaRender() {
        this.skipVanillaRender = entity -> false;
        return this;
    }

    public SimpleEntityVisualizer<T> apply(boolean enabledByDefault) {
        Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
        if (this.skipVanillaRender == null) {
            this.skipVanillaRender = entity -> true;
        }
        SimpleEntityVisualizer<T> visualizer = new SimpleEntityVisualizer<T>(this.visualFactory, this.skipVanillaRender);
        this.configurator.register(this.type, visualizer, enabledByDefault);
        return visualizer;
    }
}

