/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.bearing.ClockworkBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.ClockworkContraption;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkBearingBlockEntity
extends KineticBlockEntity
implements IBearingBlockEntity {
    protected ControlledContraptionEntity hourHand;
    protected ControlledContraptionEntity minuteHand;
    protected float hourAngle;
    protected float minuteAngle;
    protected float clientHourAngleDiff;
    protected float clientMinuteAngleDiff;
    protected boolean running;
    protected boolean assembleNextTick;
    protected AssemblyException lastException;
    protected ServerScrollOptionBehaviour<ClockHands> operationMode;
    private float prevForcedAngle;

    public ClockworkBearingBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CLOCKWORK_BEARING, pos, state);
        this.setLazyTickRate(3);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.operationMode = new ServerScrollOptionBehaviour<ClockHands>(ClockHands.class, this);
        behaviours.add(this.operationMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CLOCKWORK_BEARING);
    }

    @Override
    public boolean isWoodenTop() {
        return false;
    }

    @Override
    public void tick() {
        float newAngle;
        super.tick();
        if (this.field_11863.field_9236) {
            this.prevForcedAngle = this.hourAngle;
            this.clientMinuteAngleDiff /= 2.0f;
            this.clientHourAngleDiff /= 2.0f;
        }
        if (!this.field_11863.field_9236 && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble = true;
                if (this.speed == 0.0f && (canDisassemble || this.hourHand == null || this.hourHand.getContraption().getBlocks().isEmpty())) {
                    if (this.hourHand != null) {
                        this.hourHand.getContraption().stop(this.field_11863);
                    }
                    if (this.minuteHand != null) {
                        this.minuteHand.getContraption().stop(this.field_11863);
                    }
                    this.disassemble();
                }
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.hourHand == null || !this.hourHand.isStalled()) {
            newAngle = this.hourAngle + this.getHourArmSpeed();
            this.hourAngle = newAngle % 360.0f;
        }
        if (this.minuteHand == null || !this.minuteHand.isStalled()) {
            newAngle = this.minuteAngle + this.getMinuteArmSpeed();
            this.minuteAngle = newAngle % 360.0f;
        }
        this.applyRotations();
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected void applyRotations() {
        class_2680 blockState = this.method_11010();
        class_2350.class_2351 axis = class_2350.class_2351.field_11048;
        if (blockState.method_28498((class_2769)class_2741.field_12525)) {
            axis = ((class_2350)blockState.method_11654((class_2769)class_2741.field_12525)).method_10166();
        }
        if (this.hourHand != null) {
            this.hourHand.setAngle(this.hourAngle);
            this.hourHand.setRotationAxis(axis);
        }
        if (this.minuteHand != null) {
            this.minuteHand.setAngle(this.minuteAngle);
            this.minuteHand.setRotationAxis(axis);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.hourHand != null && !this.field_11863.field_9236) {
            this.sendData();
        }
    }

    public float getHourArmSpeed() {
        float speed = this.getAngularSpeed() / 2.0f;
        if (speed != 0.0f) {
            ClockHands mode = ClockHands.values()[this.operationMode.getValue()];
            float hourTarget = mode == ClockHands.HOUR_FIRST ? this.getHourTarget(false) : (mode == ClockHands.MINUTE_FIRST ? this.getMinuteTarget() : this.getHourTarget(true));
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.hourAngle, hourTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientHourAngleDiff / 3.0f;
    }

    public float getMinuteArmSpeed() {
        float speed = this.getAngularSpeed();
        if (speed != 0.0f) {
            ClockHands mode = ClockHands.values()[this.operationMode.getValue()];
            float minuteTarget = mode == ClockHands.MINUTE_FIRST ? this.getHourTarget(false) : this.getMinuteTarget();
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.minuteAngle, minuteTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientMinuteAngleDiff / 3.0f;
    }

    protected float getHourTarget(boolean cycle24) {
        boolean isNatural = this.field_11863.method_8597().comp_645();
        int dayTime = (int)(this.field_11863.method_8532() * (long)(isNatural ? 1 : 24) % 24000L);
        int hours = (dayTime / 1000 + 6) % 24;
        int offset = ((class_2350)this.method_11010().method_11654((class_2769)ClockworkBearingBlock.FACING)).method_10171().method_10181();
        return (float)(offset * -360) / (cycle24 ? 24.0f : 12.0f) * (float)(hours % (cycle24 ? 24 : 12));
    }

    protected float getMinuteTarget() {
        boolean isNatural = this.field_11863.method_8597().comp_645();
        int dayTime = (int)(this.field_11863.method_8532() * (long)(isNatural ? 1 : 24) % 24000L);
        int minutes = dayTime % 1000 * 60 / 1000;
        int offset = ((class_2350)this.method_11010().method_11654((class_2769)ClockworkBearingBlock.FACING)).method_10171().method_10181();
        return (float)(offset * -360) / 60.0f * (float)minutes;
    }

    public float getAngularSpeed() {
        float speed = -Math.abs(this.getSpeed() * 3.0f / 10.0f);
        if (this.field_11863.field_9236) {
            speed *= AllClientHandle.INSTANCE.getServerSpeed();
        }
        return speed;
    }

    public void assemble() {
        Pair<ClockworkContraption, ClockworkContraption> contraption;
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof ClockworkBearingBlock)) {
            return;
        }
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        try {
            contraption = ClockworkContraption.assembleClockworkAt(this.field_11863, this.field_11867, direction);
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption == null) {
            return;
        }
        if (contraption.getLeft() == null) {
            return;
        }
        if (((ClockworkContraption)contraption.getLeft()).getBlocks().isEmpty()) {
            return;
        }
        class_2338 anchor = this.field_11867.method_10093(direction);
        ((ClockworkContraption)contraption.getLeft()).removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
        this.hourHand = ControlledContraptionEntity.create(this.field_11863, this, (Contraption)contraption.getLeft());
        this.hourHand.method_23327(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        this.hourHand.setRotationAxis(direction.method_10166());
        this.field_11863.method_8649((class_1297)this.hourHand);
        if (((ClockworkContraption)contraption.getLeft()).containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        if (contraption.getRight() != null) {
            anchor = this.field_11867.method_10079(direction, ((ClockworkContraption)contraption.getRight()).offset + 1);
            ((ClockworkContraption)contraption.getRight()).removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
            this.minuteHand = ControlledContraptionEntity.create(this.field_11863, this, (Contraption)contraption.getRight());
            this.minuteHand.method_23327(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
            this.minuteHand.setRotationAxis(direction.method_10166());
            this.field_11863.method_8649((class_1297)this.minuteHand);
            if (((ClockworkContraption)contraption.getRight()).containsBlockBreakers()) {
                this.award(AllAdvancements.CONTRAPTION_ACTORS);
            }
        }
        this.award(AllAdvancements.CLOCKWORK_BEARING);
        this.running = true;
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.sendData();
    }

    public void disassemble() {
        if (!this.running && this.hourHand == null && this.minuteHand == null) {
            return;
        }
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.applyRotations();
        if (this.hourHand != null) {
            this.hourHand.disassemble();
        }
        if (this.minuteHand != null) {
            this.minuteHand.disassemble();
        }
        this.hourHand = null;
        this.minuteHand = null;
        this.running = false;
        this.sendData();
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        Contraption contraption2 = contraption.getContraption();
        if (!(contraption2 instanceof ClockworkContraption)) {
            return;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption2;
        this.method_5431();
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_2338 anchor = this.field_11867.method_10079(facing, cc.offset + 1);
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            this.hourHand = contraption;
            this.hourHand.method_23327(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        } else {
            this.minuteHand = contraption;
            this.minuteHand.method_23327(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
        }
        if (!this.field_11863.field_9236) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", this.running);
        view.method_71464("HourAngle", this.hourAngle);
        view.method_71464("MinuteAngle", this.minuteAngle);
        AssemblyException.write(view, this.lastException);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        float hourAngleBefore = this.hourAngle;
        float minuteAngleBefore = this.minuteAngle;
        this.running = view.method_71433("Running", false);
        this.hourAngle = view.method_71423("HourAngle", 0.0f);
        this.minuteAngle = view.method_71423("MinuteAngle", 0.0f);
        this.lastException = AssemblyException.read(view);
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            this.clientHourAngleDiff = AngleHelper.getShortestAngleDiff(hourAngleBefore, this.hourAngle);
            this.clientMinuteAngleDiff = AngleHelper.getShortestAngleDiff(minuteAngleBefore, this.minuteAngle);
            this.hourAngle = hourAngleBefore;
            this.minuteAngle = minuteAngleBefore;
        } else {
            this.hourHand = null;
            this.minuteHand = null;
        }
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)partialTicks, (float)this.prevForcedAngle, (float)this.hourAngle);
        }
        if (this.hourHand == null || this.hourHand.isStalled()) {
            partialTicks = 0.0f;
        }
        return class_3532.method_16439((float)partialTicks, (float)this.hourAngle, (float)(this.hourAngle + this.getHourArmSpeed()));
    }

    @Override
    public void onStall() {
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    @Override
    public void remove() {
        if (!this.field_11863.field_9236) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        Contraption contraption2 = contraption.getContraption();
        if (!(contraption2 instanceof ClockworkContraption)) {
            return false;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption2;
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            return this.hourHand == contraption;
        }
        return this.minuteHand == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setAngle(float forcedAngle) {
        this.hourAngle = forcedAngle;
    }

    @Override
    public class_2338 getBlockPosition() {
        return this.field_11867;
    }

    public static enum ClockHands {
        HOUR_FIRST,
        MINUTE_FIRST,
        HOUR_FIRST_24;

    }
}

