/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.clipboard;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3965;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class ClipboardValueSettingsHandler {
    public static class_1269 rightClickToCopy(class_1937 world, class_1657 player, class_1799 itemStack, class_1268 hand, class_3965 hit, class_2338 pos) {
        return ClipboardValueSettingsHandler.interact(world, player, itemStack, hit.method_17780(), pos, false);
    }

    public static boolean leftClickToPaste(class_1937 world, class_1657 player, class_1799 itemStack, class_2350 side, class_2338 pos) {
        return ClipboardValueSettingsHandler.interact(world, player, itemStack, side, pos, true) == class_1269.field_5812;
    }

    private static class_1269 interact(class_1937 world, class_1657 player, class_1799 itemStack, class_2350 side, class_2338 pos, boolean paste) {
        boolean anyValid;
        boolean anySuccess;
        class_2487 tag;
        ClipboardContent clipboardContent;
        block26: {
            if (!itemStack.method_31574((class_1792)AllItems.CLIPBOARD) || player.method_7325() || player.method_5715()) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            if (!(class_25862 instanceof SmartBlockEntity)) {
                return null;
            }
            SmartBlockEntity smartBE = (SmartBlockEntity)class_25862;
            clipboardContent = (ClipboardContent)itemStack.method_58695(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY);
            if (smartBE instanceof ClipboardBlockEntity) {
                ClipboardBlockEntity cbe = (ClipboardBlockEntity)smartBE;
                if (!world.field_9236) {
                    List<List<ClipboardEntry>> listTo = ClipboardEntry.readAll(clipboardContent);
                    List<List<ClipboardEntry>> listFrom = ClipboardEntry.readAll(cbe.method_58693());
                    ArrayList<ClipboardEntry> toAdd = new ArrayList<ClipboardEntry>();
                    for (List<ClipboardEntry> page : listFrom) {
                        block6: for (ClipboardEntry clipboardEntry : page) {
                            String string = clipboardEntry.text.getString();
                            for (List<ClipboardEntry> pageTo : listTo) {
                                for (ClipboardEntry existing : pageTo) {
                                    if (!string.equals(existing.text.getString())) continue;
                                    continue block6;
                                }
                            }
                            toAdd.add(new ClipboardEntry(clipboardEntry.checked, clipboardEntry.text));
                        }
                    }
                    for (ClipboardEntry entry : toAdd) {
                        List<ClipboardEntry> page = null;
                        for (List<ClipboardEntry> list : listTo) {
                            if (list.size() > 11) continue;
                            page = list;
                            break;
                        }
                        if (page == null) {
                            page = new ArrayList<ClipboardEntry>();
                            listTo.add(page);
                        }
                        page.add(entry);
                        clipboardContent = clipboardContent.setType(ClipboardType.WRITTEN);
                        itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboardContent);
                    }
                    clipboardContent = clipboardContent.setPages(listTo);
                    itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboardContent);
                }
                player.method_7353((class_2561)class_2561.method_43469((String)"create.clipboard.copied_from_clipboard", (Object[])new Object[]{world.method_8320(pos).method_26204().method_9518().method_27692(class_124.field_1068)}).method_27692(class_124.field_1060), true);
                return class_1269.field_5812;
            }
            tag = null;
            if (paste && (tag = (class_2487)clipboardContent.copiedValues().orElse(null)) == null) {
                return null;
            }
            anySuccess = false;
            anyValid = false;
            try (class_8942.class_11340 logging = new class_8942.class_11340(smartBE.method_71402(), Create.LOGGER);){
                class_11362 writeView;
                class_5455 registryManager = world.method_30349();
                class_11368 readView = paste ? class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)tag) : null;
                class_11362 class_113622 = writeView = paste ? null : class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registryManager);
                if (smartBE instanceof ClipboardCloneable) {
                    ClipboardCloneable clipboardCloneable = (ClipboardCloneable)((Object)smartBE);
                    anyValid = true;
                    if (paste) {
                        anySuccess = ClipboardValueSettingsHandler.paste(clipboardCloneable, player, readView, side, world.field_9236);
                    } else {
                        anySuccess = ClipboardValueSettingsHandler.write(clipboardCloneable, (class_7225.class_7874)registryManager, (class_11372)writeView, side, world.field_9236);
                        if (anySuccess) {
                            tag = writeView.method_71475();
                        }
                    }
                }
                if (anySuccess) break block26;
                for (BehaviourType<ServerLinkBehaviour> behaviourType : List.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE)) {
                    ServerLinkBehaviour serverLinkBehaviour = smartBE.getBehaviour(behaviourType);
                    if (!(serverLinkBehaviour instanceof ClipboardCloneable)) continue;
                    ClipboardCloneable cc = serverLinkBehaviour;
                    anyValid = true;
                    if (paste) {
                        anySuccess = ClipboardValueSettingsHandler.paste(cc, player, readView, side, world.field_9236);
                        continue;
                    }
                    anySuccess = ClipboardValueSettingsHandler.write(cc, (class_7225.class_7874)registryManager, (class_11372)writeView, side, world.field_9236);
                    if (!anySuccess) continue;
                    tag = writeView.method_71475();
                    break;
                }
            }
        }
        if (!anyValid) {
            return null;
        }
        if (world.method_8608() || !anySuccess) {
            return class_1269.field_5812;
        }
        player.method_7353((class_2561)class_2561.method_43469((String)(paste ? "create.clipboard.pasted_to" : "create.clipboard.copied_from"), (Object[])new Object[]{world.method_8320(pos).method_26204().method_9518().method_27692(class_124.field_1068)}).method_27692(class_124.field_1060), true);
        if (!paste) {
            clipboardContent = clipboardContent.setType(ClipboardType.WRITTEN);
            clipboardContent = clipboardContent.setCopiedValues(tag);
            itemStack.method_57379(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboardContent);
        }
        return class_1269.field_5812;
    }

    private static boolean paste(ClipboardCloneable cc, class_1657 player, class_11368 readView, class_2350 side, boolean simulate) {
        return readView.method_71420(cc.getClipboardKey()).map(v -> cc.readFromClipboard((class_11368)v, player, side, simulate)).orElse(false);
    }

    private static boolean write(ClipboardCloneable cc, class_7225.class_7874 registryManager, class_11372 writeView, class_2350 side, boolean simulate) {
        String clipboardKey = cc.getClipboardKey();
        if (simulate) {
            return cc.canWrite(registryManager, side);
        }
        return cc.writeToClipboard(writeView.method_71461(clipboardKey), side);
    }
}

