/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.steamEngine;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;

public class SteamEngineBlock
extends class_2341
implements class_3737,
IWrenchable,
IBE<SteamEngineBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());
    public static final MapCodec<SteamEngineBlock> CODEC = SteamEngineBlock.method_54094(SteamEngineBlock::new);

    public SteamEngineBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)class_2738.field_12475)).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(new class_2769[]{field_11007, field_11177, class_2741.field_12508}));
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return SteamEngineBlock.canAttach(pLevel, pPos, SteamEngineBlock.getConnectedDirection(pState).method_10153());
    }

    public static boolean canAttach(class_4538 pReader, class_2338 pPos, class_2350 pDirection) {
        class_2338 blockpos = pPos.method_10093(pDirection);
        return pReader.method_8320(blockpos).method_26204() instanceof FluidTankBlock;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (placementHelper.matchesItem(stack)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747)stack.method_7909(), player, hand);
        }
        return class_1269.field_52423;
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighbourPos, class_2680 neighbourState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return state;
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.method_10093(SteamEngineBlock.getFacing(pState).method_10153()));
        class_2338 shaftPos = SteamEngineBlock.getShaftPos(pState, pPos);
        class_2680 shaftState = pLevel.method_8320(shaftPos);
        if (SteamEngineBlock.isShaftValid(pState, shaftState)) {
            pLevel.method_8652(shaftPos, PoweredShaftBlock.getEquivalent(shaftState), 3);
        }
    }

    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        if (pState.method_31709()) {
            pLevel.method_8544(pPos);
        }
        FluidTankBlock.updateBoilerState(pState, (class_1937)pLevel, pPos.method_10093(SteamEngineBlock.getFacing(pState).method_10153()));
        class_2338 shaftPos = SteamEngineBlock.getShaftPos(pState, pPos);
        class_2680 shaftState = pLevel.method_8320(shaftPos);
        if (shaftState.method_27852((class_2248)AllBlocks.POWERED_SHAFT)) {
            pLevel.method_64310(shaftPos, shaftState.method_26204(), 1);
        }
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        class_2738 face = (class_2738)pState.method_11654((class_2769)field_11007);
        class_2350 direction = (class_2350)pState.method_11654((class_2769)field_11177);
        return face == class_2738.field_12473 ? AllShapes.STEAM_ENGINE_CEILING.get(direction.method_10166()) : (face == class_2738.field_12475 ? AllShapes.STEAM_ENGINE.get(direction.method_10166()) : AllShapes.STEAM_ENGINE_WALL.get(direction));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_3610 ifluidstate = level.method_8316(pos);
        class_2680 state = super.method_9605(context);
        if (state == null) {
            return null;
        }
        return (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(ifluidstate.method_15772() == class_3612.field_15910));
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public static class_2350 getFacing(class_2680 sideState) {
        return SteamEngineBlock.getConnectedDirection(sideState);
    }

    public static class_2338 getShaftPos(class_2680 sideState, class_2338 pos) {
        return pos.method_10079(SteamEngineBlock.getConnectedDirection(sideState), 2);
    }

    public static boolean isShaftValid(class_2680 state, class_2680 shaft) {
        return (shaft.method_27852((class_2248)AllBlocks.SHAFT) || shaft.method_27852((class_2248)AllBlocks.POWERED_SHAFT)) && shaft.method_11654((class_2769)ShaftBlock.AXIS) != SteamEngineBlock.getFacing(state).method_10166();
    }

    @Override
    public Class<SteamEngineBlockEntity> getBlockEntityClass() {
        return SteamEngineBlockEntity.class;
    }

    @Override
    public class_2591<? extends SteamEngineBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.STEAM_ENGINE;
    }

    public static Couple<Integer> getSpeedRange() {
        return Couple.create(16, 64);
    }

    public static class_2350 getConnectedDirection(class_2680 state) {
        return class_2341.method_10119((class_2680)state);
    }

    @NotNull
    protected MapCodec<? extends class_2341> method_53969() {
        return CODEC;
    }

    @class_6328
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574((class_1792)AllItems.SHAFT);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return s -> s.method_26204() instanceof SteamEngineBlock;
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 direction;
            class_2338 shaftPos = SteamEngineBlock.getShaftPos(state, pos);
            class_2680 shaft = AllBlocks.SHAFT.method_9564();
            class_2350[] class_2350Array = class_2350.method_10159((class_1297)player);
            int n = class_2350Array.length;
            for (int i = 0; i < n && !SteamEngineBlock.isShaftValid(state, shaft = (class_2680)shaft.method_11657((class_2769)ShaftBlock.AXIS, (Comparable)(direction = class_2350Array[i]).method_10166())); ++i) {
            }
            class_2680 newState = world.method_8320(shaftPos);
            if (!newState.method_45474()) {
                return PlacementOffset.fail();
            }
            class_2350.class_2351 axis = (class_2350.class_2351)shaft.method_11654((class_2769)ShaftBlock.AXIS);
            return PlacementOffset.success((class_2382)shaftPos, s -> (class_2680)BlockHelper.copyProperties(s, (world.field_9236 ? AllBlocks.SHAFT : AllBlocks.POWERED_SHAFT).method_9564()).method_11657((class_2769)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }
}

