package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.catnip.theme.Color;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

import static com.zurrtum.create.client.catnip.render.PonderRenderPipelines.POSITION_COLOR_TRIANGLES;

public record BreadcrumbArrowRenderState(
    Matrix3x2f pose, float x0, float x1, float x2, float x3, float y0, float y1, float y2, int fc1Color, int fc2Color, int fc3Color, int fc4Color,
    class_8030 bounds
) implements class_11244 {
    public BreadcrumbArrowRenderState(
        Matrix3x2f pose,
        float x0,
        float x1,
        float x2,
        float x3,
        float y0,
        float y1,
        float y2,
        Color f1,
        Color f2,
        Color f3,
        Color f4,
        int width,
        int height
    ) {
        this(
            pose,
            x0,
            x1,
            x2,
            x3,
            y0,
            y1,
            y2,
            f1.getRGB(),
            f2.getRGB(),
            f3.getRGB(),
            f4.getRGB(),
            new class_8030(0, 0, width, height).method_71523(pose)
        );
    }

    @Override
    public RenderPipeline comp_4055() {
        return POSITION_COLOR_TRIANGLES;
    }

    @Override
    public void method_70917(class_4588 vertexConsumer, float depth) {
        vertexConsumer.method_70815(pose, x0, y1, depth).method_39415(fc1Color);
        vertexConsumer.method_70815(pose, x1, y0, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x1, y1, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x0, y1, depth).method_39415(fc1Color);
        vertexConsumer.method_70815(pose, x1, y1, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x1, y2, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x1, y2, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x1, y0, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x2, y0, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x1, y2, depth).method_39415(fc2Color);
        vertexConsumer.method_70815(pose, x2, y0, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x2, y2, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x2, y1, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x2, y0, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x3, y0, depth).method_39415(fc4Color);
        vertexConsumer.method_70815(pose, x2, y2, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x2, y1, depth).method_39415(fc3Color);
        vertexConsumer.method_70815(pose, x3, y2, depth).method_39415(fc4Color);
    }

    @Override
    public class_11231 comp_4056() {
        return class_11231.method_70899();
    }

    @Override
    public @Nullable class_8030 comp_4069() {
        return null;
    }
}
