package com.zurrtum.create.client.catnip.gui.render;

import net.minecraft.class_11256;
import net.minecraft.class_11540;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8030;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public record ItemTransformRenderState(
    class_11540 state, Matrix3x2f pose, class_8030 bounds, int x1, int y1, int x2, int y2, int padding, float size, float xRot, float yRot,
    float zRot, @Nullable class_8030 scissor
) implements class_11256 {
    public static ItemTransformRenderState create(
        class_332 graphics,
        class_1799 stack,
        float x,
        float y,
        float scale,
        int padding,
        float xRot,
        float yRot,
        float zRot
    ) {
        class_11540 state = new class_11540();
        state.field_55337 = class_811.field_4317;
        state.method_70946(scale);
        state.method_70946(padding);
        state.method_70946(xRot);
        state.method_70946(yRot);
        state.method_70946(zRot);
        class_310 mc = graphics.field_44656;
        mc.method_65386().method_65596(state, stack, state.field_55337, mc.field_1687, mc.field_1724, 0);
        Matrix3x2f pose = new Matrix3x2f(graphics.method_51448());
        float size = scale * 16 + padding;
        int x1 = (int) x;
        int y1 = (int) y;
        int x2 = (int) (x + size);
        int y2 = (int) (y + size);
        class_8030 bounds = new class_8030(x1, y1, (int) size, (int) size).method_71523(pose);
        class_8030 scissor = graphics.field_44659.method_70863();
        if (scissor != null) {
            bounds = bounds.method_49701(scissor);
        }
        return new ItemTransformRenderState(state, pose, bounds, x1, y1, x2, y2, padding, size, xRot, yRot, zRot, scissor);
    }

    public Object getKey() {
        return state.method_72239();
    }

    @Override
    public int comp_4122() {
        return x1;
    }

    @Override
    public int comp_4124() {
        return x2;
    }

    @Override
    public int comp_4123() {
        return y1;
    }

    @Override
    public int comp_4125() {
        return y2;
    }

    @Override
    public Matrix3x2f method_72127() {
        return field_60999;
    }

    @Override
    public @Nullable class_8030 comp_4274() {
        return bounds;
    }

    @Override
    public float comp_4133() {
        return size;
    }

    @Override
    public @Nullable class_8030 comp_4128() {
        return scissor;
    }
}
