package com.zurrtum.create.client.catnip.gui.render;

import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

import java.util.function.BiConsumer;
import net.minecraft.class_10801;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_8030;

public class PartialRenderState implements class_11256 {
    public class_10801 model;
    public boolean dirty;
    public Matrix3x2f field_60999;
    public class_8030 bounds;
    public int x1, y1, x2, y2, padding;
    public float size;
    private BiConsumer<class_4587, Float> transform;
    private float partialTicks;
    public @Nullable class_8030 scissor;

    public void transform(class_4587 matrices) {
        if (transform != null) {
            transform.accept(matrices, partialTicks);
        }
    }

    public void update(
        class_332 graphics,
        PartialModel partial,
        float x,
        float y,
        float xLocal,
        float yLocal,
        float scale,
        int padding,
        float partialTicks,
        BiConsumer<class_4587, Float> transform
    ) {
        float size = scale * 16 + padding;
        if (model != partial.get()) {
            dirty = model != null;
            model = partial.get();
        } else if (size != this.size || partialTicks != this.partialTicks) {
            dirty = true;
        }
        field_60999 = new Matrix3x2f(graphics.method_51448());
        field_60999.translate(xLocal, yLocal);
        x1 = (int) x;
        y1 = (int) y;
        x2 = (int) (x + size);
        y2 = (int) (y + size);
        bounds = new class_8030(x1, y1, (int) size, (int) size).method_71523(field_60999);
        scissor = graphics.field_44659.method_70863();
        if (scissor != null) {
            bounds = bounds.method_49701(scissor);
        }
        this.size = size;
        this.padding = padding;
        this.transform = transform;
        this.partialTicks = partialTicks;
    }

    public void clearDirty() {
        dirty = false;
    }

    @Override
    public int comp_4122() {
        return x1;
    }

    @Override
    public int comp_4124() {
        return x2;
    }

    @Override
    public int comp_4123() {
        return y1;
    }

    @Override
    public int comp_4125() {
        return y2;
    }

    @Override
    public Matrix3x2f method_72127() {
        return field_60999;
    }

    @Override
    public @Nullable class_8030 comp_4274() {
        return bounds;
    }

    @Override
    public float comp_4133() {
        return size;
    }

    @Override
    public @Nullable class_8030 comp_4128() {
        return scissor;
    }
}
