package com.zurrtum.create.client.compat.rei.renderer;

import com.zurrtum.create.client.foundation.utility.CreateLang;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public record ChanceItemRenderer(float chance, EntryRenderer<class_1799> origin) implements EntryRenderer<class_1799> {
    @Override
    public void render(EntryStack<class_1799> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        origin.render(entry, graphics, bounds, mouseX, mouseY, delta);
    }

    @Override
    public @Nullable Tooltip getTooltip(EntryStack<class_1799> entry, TooltipContext context) {
        Tooltip tooltip = origin.getTooltip(entry, context);
        if (tooltip != null) {
            tooltip.add(CreateLang.translateDirect("recipe.processing.chance", chance < 0.01 ? "<1" : (int) (chance * 100))
                .method_27692(class_124.field_1065));
        }
        return tooltip;
    }
}
