package com.zurrtum.create.client.content.decoration.steamWhistle;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.WhistleAnimationBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class WhistleRenderer extends SafeBlockEntityRenderer<WhistleBlockEntity> {

    public WhistleRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(WhistleBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 blockState = be.method_11010();
        if (!(blockState.method_26204() instanceof WhistleBlock))
            return;

        class_2350 direction = blockState.method_11654(WhistleBlock.FACING);
        WhistleSize size = blockState.method_11654(WhistleBlock.SIZE);

        PartialModel mouth = size == WhistleSize.LARGE ? AllPartialModels.WHISTLE_MOUTH_LARGE : size == WhistleSize.MEDIUM ? AllPartialModels.WHISTLE_MOUTH_MEDIUM : AllPartialModels.WHISTLE_MOUTH_SMALL;

        WhistleAnimationBehaviour behaviour = (WhistleAnimationBehaviour) be.getBehaviour(AnimationBehaviour.TYPE);
        float offset = behaviour.animation.getValue(partialTicks);
        if (behaviour.animation.getChaseTarget() > 0 && behaviour.animation.getValue() > 0.5f) {
            float wiggleProgress = (AnimationTickHolder.getTicks(be.method_10997()) + partialTicks) / 8f;
            offset -= Math.sin(wiggleProgress * (2 * class_3532.field_29844) * (4 - size.ordinal())) / 16f;
        }

        CachedBuffers.partial(mouth, blockState).center().rotateYDegrees(AngleHelper.horizontalAngle(direction)).uncenter()
            .translate(0, offset * 4 / 16f, 0).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
    }

}
