package com.zurrtum.create.client.content.equipment.armor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.equipment.armor.BacktankBlock;
import com.zurrtum.create.content.equipment.armor.BacktankItem;
import net.minecraft.class_10034;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_572;

public class BacktankFeatureRenderer<S extends class_10034, M extends class_572<? super S>> extends class_3887<S, M> {
    public BacktankFeatureRenderer(class_3883<S, M> context) {
        super(context);
    }

    @Override
    public void render(class_4587 ms, class_4597 buffer, int light, S state, float limbAngle, float limbDistance) {
        if (state.field_53465 == class_4050.field_18078 || !(state.field_53418.method_7909() instanceof BacktankItem item)) {
            return;
        }

        class_4588 vc = buffer.getBuffer(class_4722.method_24074());
        class_2680 renderedState = item.method_7711().method_9564().method_11657(BacktankBlock.HORIZONTAL_FACING, class_2350.field_11035);
        SuperByteBuffer backtank = CachedBuffers.block(renderedState);
        SuperByteBuffer cogs = CachedBuffers.partial(BacktankRenderer.getCogsModel(renderedState), renderedState);
        SuperByteBuffer nob = CachedBuffers.partial(BacktankRenderer.getShaftModel(renderedState), renderedState);

        ms.method_22903();

        method_17165().field_3391.method_22703(ms);
        ms.method_46416(-1 / 2f, 10 / 16f, 1f);
        ms.method_22905(1, -1, -1);

        backtank.disableDiffuse().light(light).renderInto(ms, vc);

        nob.disableDiffuse().translate(0, -3f / 16, 0).light(light).renderInto(ms, vc);

        cogs.center().rotateYDegrees(180).uncenter().translate(0, 6.5f / 16, 11f / 16)
            .rotate(AngleHelper.rad(2 * AnimationTickHolder.getRenderTime() % 360), class_2350.field_11034).translate(0, -6.5f / 16, -11f / 16);

        cogs.disableDiffuse().light(light).renderInto(ms, vc);

        ms.method_22909();
    }
}
