package com.zurrtum.create.client.content.fluids.spout;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.fluids.spout.SpoutBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class SpoutRenderer extends SafeBlockEntityRenderer<SpoutBlockEntity> {

    public SpoutRenderer(class_5614.class_5615 context) {
    }

    static final PartialModel[] BITS = {AllPartialModels.SPOUT_TOP, AllPartialModels.SPOUT_MIDDLE, AllPartialModels.SPOUT_BOTTOM};

    @Override
    protected void renderSafe(SpoutBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null)
            return;

        TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);

        if (!fluidStack.isEmpty() && level != 0) {
            boolean top = false;//TODO fluidStack.getFluid().getFluidType().isLighterThanAir();

            level = Math.max(level, 0.175f);
            float min = 2.5f / 16f;
            float max = min + (11 / 16f);
            float yOffset = (11 / 16f) * level;

            ms.method_22903();
            if (!top)
                ms.method_46416(0, yOffset, 0);
            else
                ms.method_46416(0, max - min, 0);

            FluidRenderHelper.renderFluidBox(fluidStack, min, min - yOffset, min, max, min, max, buffer, ms, light, false, true);

            ms.method_22909();
        }

        int processingTicks = be.processingTicks;
        float processingPT = processingTicks - partialTicks;
        float processingProgress = 1 - (processingPT - 5) / 10;
        processingProgress = class_3532.method_15363(processingProgress, 0, 1);
        float radius = 0;

        if (!fluidStack.isEmpty() && processingTicks != -1) {
            radius = (float) (Math.pow(((2 * processingProgress) - 1), 2) - 1);
            class_238 bb = new class_238(0.5, 0.0, 0.5, 0.5, -1.2, 0.5).method_1014(radius / 32f);
            FluidRenderHelper.renderFluidBox(
                fluidStack,
                (float) bb.field_1323,
                (float) bb.field_1322,
                (float) bb.field_1321,
                (float) bb.field_1320,
                (float) bb.field_1325,
                (float) bb.field_1324,
                buffer,
                ms,
                light,
                true,
                true
            );
        }

        float squeeze = radius;
        if (processingPT < 0)
            squeeze = 0;
        else if (processingPT < 2)
            squeeze = class_3532.method_48781(processingPT / 2f, 0, -1);
        else if (processingPT < 10)
            squeeze = -1;

        ms.method_22903();
        for (PartialModel bit : BITS) {
            CachedBuffers.partial(bit, be.method_11010()).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
            ms.method_46416(0, -3 * squeeze / 32f, 0);
        }
        ms.method_22909();

    }

}
