package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlock;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.ChainConveyorConnectionPacket;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ChainConveyorConnectionHandler {

    private static class_2338 firstPos;
    private static class_5321<class_1937> firstDim;

    public static boolean onRightClick(class_310 mc) {
        if (!isChain(mc.field_1724.method_6047()))
            return false;
        if (firstPos == null)
            return false;
        boolean missed = false;
        if (mc.field_1765 instanceof class_3965 bhr && bhr.method_17783() != class_240.field_1333)
            if (!(mc.field_1687.method_8321(bhr.method_17777()) instanceof ChainConveyorBlockEntity))
                missed = true;
        if (!mc.field_1724.method_5715() && !missed)
            return false;
        firstPos = null;
        CreateLang.translate("chain_conveyor.selection_cleared").sendStatus(mc.field_1724);
        return true;
    }

    public static class_1269 onItemUsedOnBlock(class_1937 level, class_746 player, class_1268 hand, class_3965 ray) {
        class_1799 itemStack = player.method_5998(hand);
        class_2338 pos = ray.method_17777();
        class_2680 blockState = level.method_8320(pos);

        if (!blockState.method_27852(AllBlocks.CHAIN_CONVEYOR) || !isChain(itemStack) || !player.method_7294() || FakePlayerHandler.has(player)) {
            return null;
        }

        if (level.method_8321(pos) instanceof ChainConveyorBlockEntity ccbe && ccbe.connections.size() >= AllConfigs.server().kinetics.maxChainConveyorConnections.get()) {
            CreateLang.translate("chain_conveyor.cannot_add_more_connections").style(class_124.field_1061).sendStatus(player);
            return class_1269.field_21466;
        }

        if (firstPos == null || firstDim != level.method_27983()) {
            firstPos = pos;
            firstDim = level.method_27983();
            player.method_6104(hand);
            return class_1269.field_21466;
        }

        boolean success = validateAndConnect(level, pos, player, itemStack, false);
        firstPos = null;

        if (!success) {
            AllSoundEvents.DENY.play(level, player, pos);
            return class_1269.field_21466;
        }

        class_2498 soundtype = class_2246.field_23985.method_9564().method_26231();
        if (soundtype != null)
            level.method_8396(
                player,
                pos,
                soundtype.method_10598(),
                class_3419.field_15245,
                (soundtype.method_10597() + 1.0F) / 2.0F,
                soundtype.method_10599() * 0.8F
            );
        return class_1269.field_21466;
    }

    private static boolean isChain(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_23983); // Replace with tag? generic renderer?
    }

    public static void clientTick(class_310 mc) {
        if (firstPos == null)
            return;

        class_746 player = mc.field_1724;
        class_638 level = player.field_17892;
        class_2586 sourceLift = level.method_8321(firstPos);

        if (firstDim != level.method_27983() || !(sourceLift instanceof ChainConveyorBlockEntity)) {
            firstPos = null;
            CreateLang.translate("chain_conveyor.selection_cleared").sendStatus(player);
            return;
        }

        class_1799 stack = player.method_6047();
        class_239 hitResult = mc.field_1765;

        if (!isChain(stack)) {
            stack = player.method_6079();
            if (!isChain(stack))
                return;
        }

        if (hitResult == null || hitResult.method_17783() != class_240.field_1332) {
            highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            return;
        }

        class_3965 bhr = (class_3965) hitResult;
        class_2338 pos = bhr.method_17777();
        class_2680 hitState = level.method_8320(pos);

        if (pos.equals(firstPos)) {
            highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            CreateLang.translate("chain_conveyor.select_second").sendStatus(player);
            return;
        }

        if (!(hitState.method_26204() instanceof ChainConveyorBlock)) {
            highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            return;
        }

        boolean success = validateAndConnect(level, pos, player, stack, true);

        if (success)
            CreateLang.translate("chain_conveyor.valid_connection").style(class_124.field_1060).sendStatus(player);

        int color = success ? 0x95CD41 : 0xEA5C2B;

        highlightConveyor(firstPos, color, "chain_connect");
        highlightConveyor(pos, color, "chain_connect_to");

        class_243 from = class_243.method_24953(pos);
        class_243 to = class_243.method_24953(firstPos);
        class_243 diff = from.method_1020(to);

        if (diff.method_1033() < 1)
            return;

        from = from.method_1020(diff.method_1029().method_1021(.5));
        to = to.method_1019(diff.method_1029().method_1021(.5));

        class_243 normal = diff.method_1036(new class_243(0, 1, 0)).method_1029().method_1021(.875);

        Outliner.getInstance().showLine("chain_connect_line", from.method_1019(normal), to.method_1019(normal)).lineWidth(1 / 16f).colored(color);
        Outliner.getInstance().showLine("chain_connect_line_1", from.method_1020(normal), to.method_1020(normal)).lineWidth(1 / 16f).colored(color);

    }

    private static void highlightConveyor(class_2338 pos, int color, String key) {
        for (int y : Iterate.zeroAndOne) {
            class_243 prevV = VecHelper.rotate(new class_243(0, .125 + y * .75, 1.25), -22.5, class_2351.field_11052).method_1019(class_243.method_24955(pos));
            for (int i = 0; i < 8; i++) {
                class_243 v = VecHelper.rotate(new class_243(0, .125 + y * .75, 1.25), 22.5 + i * 45, class_2351.field_11052).method_1019(class_243.method_24955(pos));
                Outliner.getInstance().showLine(key + y + i, prevV, v).lineWidth(1 / 16f).colored(color);
                prevV = v;
            }
        }
    }

    public static boolean validateAndConnect(class_1936 level, class_2338 pos, class_746 player, class_1799 chain, boolean simulate) {
        if (!simulate && player.method_5715()) {
            CreateLang.translate("chain_conveyor.selection_cleared").sendStatus(player);
            return false;
        }

        if (pos.equals(firstPos))
            return false;
        if (!pos.method_19771(firstPos, AllConfigs.server().kinetics.maxChainConveyorLength.get()))
            return fail("chain_conveyor.too_far", player);
        if (pos.method_19771(firstPos, 2.5))
            return fail("chain_conveyor.too_close", player);

        class_243 diff = class_243.method_24954(pos.method_10059(firstPos));
        double horizontalDistance = diff.method_18805(1, 0, 1).method_1033() - 1.5;

        if (horizontalDistance <= 0)
            return fail("chain_conveyor.cannot_connect_vertically", player);
        if (Math.abs(diff.field_1351) / horizontalDistance > 1)
            return fail("chain_conveyor.too_steep", player);

        ChainConveyorBlock chainConveyorBlock = AllBlocks.CHAIN_CONVEYOR;
        ChainConveyorBlockEntity sourceLift = chainConveyorBlock.getBlockEntity(level, firstPos);
        ChainConveyorBlockEntity targetLift = chainConveyorBlock.getBlockEntity(level, pos);

        if (targetLift.connections.size() >= AllConfigs.server().kinetics.maxChainConveyorConnections.get())
            return fail("chain_conveyor.cannot_add_more_connections", player);
        if (targetLift.connections.contains(firstPos.method_10059(pos)))
            return fail("chain_conveyor.already_connected", player);
        if (sourceLift == null || targetLift == null)
            return fail("chain_conveyor.blocks_invalid", player);

        if (!player.method_68878()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost(pos.method_10059(firstPos));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory(player, chain, chainCost, true);
            if (simulate)
                BlueprintOverlayRenderer.displayChainRequirements(chain.method_7909(), chainCost, hasEnough);
            if (!hasEnough)
                return fail("chain_conveyor.not_enough_chains", player);
        }

        if (simulate)
            return true;

        player.field_3944.method_52787(new ChainConveyorConnectionPacket(firstPos, pos, chain, true));

        CreateLang.text("") // Clear status message
            .sendStatus(player);
        firstPos = null;
        firstDim = null;
        return true;
    }

    private static boolean fail(String message, class_1657 player) {
        CreateLang.translate(message).style(class_124.field_1061).sendStatus(player);
        return false;
    }

}
