package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import net.minecraft.class_10017;
import net.minecraft.class_10039;
import net.minecraft.class_1542;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_916;

public class EjectorItemEntityRenderer extends class_916 {
    public EjectorItemEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public class_10039 method_55269() {
        return new RenderState();
    }

    @Override
    protected float getShadowRadius(class_10039 state) {
        if (((RenderState) state).alive) {
            return super.method_55831(state);
        }
        return 0;
    }

    @Override
    public void method_62470(class_1542 itemEntity, class_10039 itemEntityRenderState, float f) {
        super.method_62470(itemEntity, itemEntityRenderState, f);
        EjectorItemEntity entity = (EjectorItemEntity) itemEntity;
        RenderState state = (RenderState) itemEntityRenderState;
        state.alive = entity.method_5805();
        if (state.alive) {
            if (entity.data.initAge == -1) {
                itemEntityRenderState.field_53328 = 0;
            } else {
                itemEntityRenderState.field_53328 = (entity.field_6012 - entity.data.initAge + f) / 10.0F;
            }
        } else {
            state.rotateY = entity.data.rotateY;
            float time = entity.progress + f;
            state.rotateX = class_3532.field_29847 * time * 40;
            state.location = entity.getLaunchedItemLocation(time).method_1020(entity.method_19538());
        }
        itemEntityRenderState.field_53435 = entity.data.animateOffset;
    }

    @Override
    public class_238 getBoundingBox(class_1542 itemEntity) {
        EjectorItemEntity entity = (EjectorItemEntity) itemEntity;
        if (entity.method_5805()) {
            return entity.method_5829();
        } else {
            return entity.data.renderBox;
        }
    }

    @Override
    public void method_3996(class_10039 itemEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        if (!itemEntityRenderState.field_55310.method_65606()) {
            RenderState state = (RenderState) itemEntityRenderState;
            class_238 box = itemEntityRenderState.field_55310.method_72173();
            matrixStack.method_22903();
            float f = -((float) box.field_1322) + 0.0625F;
            matrixStack.method_46416(0, state.field_53435 + f, -0.0625f);
            if (!state.alive) {
                matrixStack.method_61958(state.location);
                matrixStack.method_46416(0, 0.25f, 0);
                if (state.rotateY != 0) {
                    matrixStack.method_22907(class_7833.field_40716.rotation(state.rotateY));
                }
                matrixStack.method_22907(class_7833.field_40714.rotation(state.rotateX));
                matrixStack.method_46416(0, -0.25f, 0);
            } else if (itemEntityRenderState.field_53328 > 0) {
                float g = class_3532.method_15374(itemEntityRenderState.field_53328) * 0.1F + 0.1F;
                matrixStack.method_46416(0, g, 0);
                matrixStack.method_22907(class_7833.field_40716.rotation(itemEntityRenderState.field_53328 / 2F));
            }
            method_56858(matrixStack, vertexConsumerProvider, i, itemEntityRenderState, field_4725, box);
            matrixStack.method_22909();

            if (state.alive) {
                if (state.field_60160 != null) {
                    for (class_10017.class_10018 leashData : state.field_60160) {
                        method_61049(matrixStack, vertexConsumerProvider, leashData);
                    }
                }

                if (state.field_53337 != null) {
                    this.method_3926(state, state.field_53337, matrixStack, vertexConsumerProvider, i);
                }
            }
        }
    }

    public static class RenderState extends class_10039 {
        public boolean alive;
        public float rotateY;
        public float rotateX;
        public class_243 location;
    }
}
