package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public class EjectorSlot extends ValueBoxTransform.Sided {
    private final EjectorBlockEntity blockEntity;

    public EjectorSlot(EjectorBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
        if (direction != class_2350.field_11036)
            return super.getLocalOffset(level, pos, state);
        return new class_243(.5, 10.5 / 16f, .5).method_1019(VecHelper.rotate(VecHelper.voxelSpace(0, 0, -5), angle(state), class_2351.field_11052));
    }

    @Override
    public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
        if (direction != class_2350.field_11036) {
            super.rotate(level, pos, state, ms);
            return;
        }
        TransformStack.of(ms).rotateYDegrees(angle(state)).rotateXDegrees(90);
    }

    protected float angle(class_2680 state) {
        return state.method_27852(AllBlocks.WEIGHTED_EJECTOR) ? AngleHelper.horizontalAngle(state.method_11654(EjectorBlock.HORIZONTAL_FACING)) : 0;
    }

    @Override
    protected boolean isSideActive(class_2680 state, class_2350 direction) {
        return direction.method_10166() == state.method_11654(EjectorBlock.HORIZONTAL_FACING)
            .method_10166() || direction == class_2350.field_11036 && blockEntity.getState() != EjectorBlockEntity.State.CHARGED;
    }

    @Override
    protected class_243 getSouthLocation() {
        return direction == class_2350.field_11036 ? class_243.field_1353 : VecHelper.voxelSpace(8, 6, 15.5);
    }

}
