package com.zurrtum.create.client.content.logistics.filter;

import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.filter.FilterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket.Option;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_9129;

public class FilterScreen extends AbstractFilterScreen<FilterMenu> {

    private static final String PREFIX = "gui.filter.";

    private final class_2561 allowN = CreateLang.translateDirect(PREFIX + "allow_list");
    private final class_2561 allowDESC = CreateLang.translateDirect(PREFIX + "allow_list.description");
    private final class_2561 denyN = CreateLang.translateDirect(PREFIX + "deny_list");
    private final class_2561 denyDESC = CreateLang.translateDirect(PREFIX + "deny_list.description");

    private final class_2561 respectDataN = CreateLang.translateDirect(PREFIX + "respect_data");
    private final class_2561 respectDataDESC = CreateLang.translateDirect(PREFIX + "respect_data.description");
    private final class_2561 ignoreDataN = CreateLang.translateDirect(PREFIX + "ignore_data");
    private final class_2561 ignoreDataDESC = CreateLang.translateDirect(PREFIX + "ignore_data.description");

    private IconButton whitelist, blacklist;
    private IconButton respectNBT, ignoreNBT;

    public FilterScreen(FilterMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title, AllGuiTextures.FILTER);
    }

    public static FilterScreen create(
        class_310 mc,
        MenuType<class_1799> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(FilterScreen::new, syncId, inventory, title, getStack(extraData));
    }

    @Override
    protected void method_25426() {
        setWindowOffset(-11, 5);
        super.method_25426();

        blacklist = new IconButton(field_2776 + 18, field_2800 + 75, AllIcons.I_BLACKLIST);
        blacklist.withCallback(() -> {
            field_2797.blacklist = true;
            sendOptionUpdate(Option.BLACKLIST);
        });
        blacklist.setToolTip(denyN);
        whitelist = new IconButton(field_2776 + 36, field_2800 + 75, AllIcons.I_WHITELIST);
        whitelist.withCallback(() -> {
            field_2797.blacklist = false;
            sendOptionUpdate(Option.WHITELIST);
        });
        whitelist.setToolTip(allowN);
        addRenderableWidgets(blacklist, whitelist);

        respectNBT = new IconButton(field_2776 + 60, field_2800 + 75, AllIcons.I_RESPECT_NBT);
        respectNBT.withCallback(() -> {
            field_2797.respectNBT = true;
            sendOptionUpdate(Option.RESPECT_DATA);
        });
        respectNBT.setToolTip(respectDataN);
        ignoreNBT = new IconButton(field_2776 + 78, field_2800 + 75, AllIcons.I_IGNORE_NBT);
        ignoreNBT.withCallback(() -> {
            field_2797.respectNBT = false;
            sendOptionUpdate(Option.IGNORE_DATA);
        });
        ignoreNBT.setToolTip(ignoreDataN);
        addRenderableWidgets(respectNBT, ignoreNBT);

        handleIndicators();
    }

    @Override
    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(blacklist, whitelist, respectNBT, ignoreNBT);
    }

    @Override
    protected List<class_5250> getTooltipDescriptions() {
        return Arrays.asList(
            denyDESC.method_27662(),
            allowDESC.method_27662(),
            respectDataDESC.method_27662(),
            ignoreDataDESC.method_27662()
        );
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        if (button == blacklist)
            return !field_2797.blacklist;
        if (button == whitelist)
            return field_2797.blacklist;
        if (button == respectNBT)
            return !field_2797.respectNBT;
        if (button == ignoreNBT)
            return field_2797.respectNBT;
        return true;
    }

    @Override
    protected int getTitleColor() {
        return 0xFF303030;
    }
}
