package com.zurrtum.create.client.content.logistics.packager;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;

public class PackagerRenderer extends SmartBlockEntityRenderer<PackagerBlockEntity> {

    public PackagerRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(PackagerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);

        class_1799 renderedBox = be.getRenderedBox();
        float trayOffset = be.getTrayOffset(partialTicks);
        class_2680 blockState = be.method_11010();
        class_2350 facing = blockState.method_11654(PackagerBlock.field_10927).method_10153();

        if (!VisualizationManager.supportsVisualization(be.method_10997())) {
            var hatchModel = getHatchModel(be);

            SuperByteBuffer sbb = CachedBuffers.partial(hatchModel, blockState);
            sbb.translate(class_243.method_24954(facing.method_62675()).method_1021(.49999f)).rotateYCenteredDegrees(AngleHelper.horizontalAngle(facing))
                .rotateXCenteredDegrees(AngleHelper.verticalAngle(facing)).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));

            sbb = CachedBuffers.partial(getTrayModel(blockState), blockState);
            sbb.translate(class_243.method_24954(facing.method_62675()).method_1021(trayOffset)).rotateYCenteredDegrees(facing.method_10144())
                .light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
        }

        if (!renderedBox.method_7960()) {
            ms.method_22903();
            var msr = TransformStack.of(ms);
            msr.translate(class_243.method_24954(facing.method_62675()).method_1021(trayOffset)).translate(.5f, .5f, .5f)
                .rotateYDegrees(facing.method_10144()).translate(0, 2 / 16f, 0).scale(1.49f, 1.49f, 1.49f);
            class_310.method_1551().method_1480()
                .method_23177(null, renderedBox, class_811.field_4319, ms, buffer, be.method_10997(), light, overlay, 0);
            ms.method_22909();
        }
    }

    public static PartialModel getTrayModel(class_2680 blockState) {
        return blockState.method_27852(AllBlocks.PACKAGER) ? AllPartialModels.PACKAGER_TRAY_REGULAR : AllPartialModels.PACKAGER_TRAY_DEFRAG;
    }

    public static PartialModel getHatchModel(PackagerBlockEntity be) {
        return isHatchOpen(be) ? AllPartialModels.PACKAGER_HATCH_OPEN : AllPartialModels.PACKAGER_HATCH_CLOSED;
    }

    public static boolean isHatchOpen(PackagerBlockEntity be) {
        return be.animationTicks > (be.animationInward ? 1 : 5) && be.animationTicks < PackagerBlockEntity.CYCLE - (be.animationInward ? 5 : 1);
    }

}