package com.zurrtum.create.client.content.redstone.analogLever;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlock;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class AnalogLeverRenderer extends SafeBlockEntityRenderer<AnalogLeverBlockEntity> {

    public AnalogLeverRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(AnalogLeverBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        class_2680 leverState = be.method_11010();
        float state = be.clientState.getValue(partialTicks);

        class_4588 vb = buffer.getBuffer(class_1921.method_23577());

        // Handle
        SuperByteBuffer handle = CachedBuffers.partial(AllPartialModels.ANALOG_LEVER_HANDLE, leverState);
        float angle = (float) ((state / 15) * 90 / 180 * Math.PI);
        transform(handle, leverState).translate(1 / 2f, 1 / 16f, 1 / 2f).rotate(angle, class_2350.field_11034).translate(-1 / 2f, -1 / 16f, -1 / 2f);
        handle.light(light).renderInto(ms, vb);

        // Indicator
        int color = Color.mixColors(0x2C0300, 0xCD0000, state / 15f);
        SuperByteBuffer indicator = transform(CachedBuffers.partial(AllPartialModels.ANALOG_LEVER_INDICATOR, leverState), leverState);
        indicator.light(light).color(color).renderInto(ms, vb);
    }

    private SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 leverState) {
        class_2738 face = leverState.method_11654(AnalogLeverBlock.field_11007);
        float rX = face == class_2738.field_12475 ? 0 : face == class_2738.field_12471 ? 90 : 180;
        float rY = AngleHelper.horizontalAngle(leverState.method_11654(AnalogLeverBlock.field_11177));
        buffer.rotateCentered((float) (rY / 180 * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float) (rX / 180 * Math.PI), class_2350.field_11034);
        return buffer;
    }

}
