package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_765;

public class LinkBulbRenderer extends SafeBlockEntityRenderer<LinkWithBulbBlockEntity> {

    public LinkBulbRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(LinkWithBulbBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 blockState = be.method_11010();
        var msr = TransformStack.of(ms);

        class_2350 face = be.getBulbFacing(blockState);

        ms.method_22903();

        msr.center().rotateYDegrees(AngleHelper.horizontalAngle(face) + 180).rotateXDegrees(-AngleHelper.verticalAngle(face) - 90).uncenter();

        class_1921 translucent;
        float glow = be.getGlow(partialTicks);
        if (glow >= .125f) {
            translucent = RenderTypes.translucent();
            glow = (float) (1 - (2 * Math.pow(glow - .75f, 2)));
            glow = class_3532.method_15363(glow, -1, 1);
            int color = (int) (200 * glow);
            CachedBuffers.partial(AllPartialModels.DISPLAY_LINK_GLOW, blockState).translate(be.getBulbOffset(blockState))
                .light(class_765.field_32767).color(color, color, color, 255).disableDiffuse()
                .renderInto(ms, buffer.getBuffer(RenderTypes.additive()));
        } else {
            translucent = PonderRenderTypes.translucent();
        }
        CachedBuffers.partial(AllPartialModels.DISPLAY_LINK_TUBE, blockState).translate(be.getBulbOffset(blockState))
            .light(class_765.field_32767).renderInto(ms, buffer.getBuffer(translucent));

        ms.method_22909();
    }

}
