package com.zurrtum.create.client.content.schematics.client.tools;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;

public class DeployTool extends PlacementToolBase {

    @Override
    public void init() {
        super.init();
        selectionRange = -1;
    }

    @Override
    public void updateSelection(class_310 mc) {
        if (schematicHandler.isActive() && selectionRange == -1) {
            selectionRange = (int) (schematicHandler.getBounds().method_1005().method_1033() / 2);
            selectionRange = class_3532.method_15340(selectionRange, 1, 100);
        }
        selectIgnoreBlocks = class_3675.method_15987(mc.method_22683().method_4490(), GLFW.GLFW_KEY_LEFT_CONTROL);
        super.updateSelection(mc);
    }

    @Override
    public void renderTool(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        super.renderTool(mc, ms, buffer, camera);

        if (selectedPos == null)
            return;

        ms.method_22903();
        float pt = AnimationTickHolder.getPartialTicks();
        double x = class_3532.method_16436(pt, lastChasingSelectedPos.field_1352, chasingSelectedPos.field_1352);
        double y = class_3532.method_16436(pt, lastChasingSelectedPos.field_1351, chasingSelectedPos.field_1351);
        double z = class_3532.method_16436(pt, lastChasingSelectedPos.field_1350, chasingSelectedPos.field_1350);

        SchematicTransformation transformation = schematicHandler.getTransformation();
        class_238 bounds = schematicHandler.getBounds();
        class_243 center = bounds.method_1005();
        class_243 rotationOffset = transformation.getRotationOffset(true);
        int centerX = (int) center.field_1352;
        int centerZ = (int) center.field_1350;
        double xOrigin = bounds.method_17939() / 2f;
        double zOrigin = bounds.method_17941() / 2f;
        class_243 origin = new class_243(xOrigin, 0, zOrigin);

        ms.method_22904(x - centerX - camera.field_1352, y - camera.field_1351, z - centerZ - camera.field_1350);
        TransformStack.of(ms).translate(origin).translate(rotationOffset).rotateYDegrees(transformation.getCurrentRotation())
            .translateBack(rotationOffset).translateBack(origin);

        AABBOutline outline = schematicHandler.getOutline();
        outline.render(mc, ms, buffer, class_243.field_1353, pt);
        outline.getParams().clearTextures();
        ms.method_22909();
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        if (!selectIgnoreBlocks)
            return super.handleMouseWheel(delta);
        selectionRange += delta;
        selectionRange = class_3532.method_15340(selectionRange, 1, 100);
        return true;
    }

    @Override
    public boolean handleRightClick(class_310 mc) {
        if (selectedPos == null)
            return super.handleRightClick(mc);
        class_243 center = schematicHandler.getBounds().method_1005();
        class_2338 target = selectedPos.method_10069(-((int) center.field_1352), 0, -((int) center.field_1350));

        class_1799 item = schematicHandler.getActiveSchematicItem();
        if (item != null) {
            item.method_57379(AllDataComponents.SCHEMATIC_DEPLOYED, true);
            item.method_57379(AllDataComponents.SCHEMATIC_ANCHOR, target);
            schematicHandler.getTransformation().startAt(target);
        }

        schematicHandler.getTransformation().moveTo(target);
        schematicHandler.markDirty();
        schematicHandler.deploy(mc);
        return true;
    }

}
