package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5250;

public class AssemblyScreen extends AbstractStationScreen {

    private IconButton quitAssembly;
    private IconButton toggleAssemblyButton;
    private List<class_2960> iconTypes;
    private ScrollInput iconTypeScroll;

    public AssemblyScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        background = AllGuiTextures.STATION_ASSEMBLING;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = guiLeft;
        int y = guiTop;
        int by = y + background.getHeight() - 24;

        class_4068 widget = field_33816.getFirst();
        if (widget instanceof IconButton ib) {
            ib.setIcon(AllIcons.I_PRIORITY_VERY_LOW);
            ib.setToolTip(CreateLang.translateDirect("station.close"));
        }

        iconTypes = TrainIconType.ALL.keySet().stream().toList();
        iconTypeScroll = new ScrollInput(x + 4, y + 17, 162, 14).titled(CreateLang.translateDirect("station.icon_type"));
        iconTypeScroll.withRange(0, iconTypes.size());
        iconTypeScroll.withStepFunction(ctx -> -iconTypeScroll.standardStep().apply(ctx));
        iconTypeScroll.calling(s -> {
            Train train = displayedTrain.get();
            if (train != null)
                train.icon = TrainIconType.byId(iconTypes.get(s));
        });
        iconTypeScroll.field_22763 = iconTypeScroll.field_22764 = false;
        method_37063(iconTypeScroll);

        toggleAssemblyButton = new WideIconButton(x + 94, by, AllGuiTextures.I_ASSEMBLE_TRAIN);
        toggleAssemblyButton.field_22763 = false;
        toggleAssemblyButton.setToolTip(CreateLang.translateDirect("station.assemble_train"));
        toggleAssemblyButton.withCallback(() -> {
            field_22787.field_1724.field_3944.method_52787(StationEditPacket.tryAssemble(blockEntity.method_11016()));
        });

        quitAssembly = new IconButton(x + 73, by, AllIcons.I_DISABLE);
        quitAssembly.field_22763 = true;
        quitAssembly.setToolTip(CreateLang.translateDirect("station.cancel"));
        quitAssembly.withCallback(() -> {
            field_22787.field_1724.field_3944.method_52787(StationEditPacket.configure(blockEntity.method_11016(), false, station.name, null));
            field_22787.method_1507(new StationScreen(blockEntity, station));
        });

        method_37063(toggleAssemblyButton);
        method_37063(quitAssembly);

        tickTrainDisplay();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        tickTrainDisplay();
        Train train = displayedTrain.get();
        toggleAssemblyButton.field_22763 = blockEntity.bogeyCount > 0 || train != null;

        if (train != null) {
            field_22787.field_1724.field_3944.method_52787(StationEditPacket.configure(blockEntity.method_11016(), false, station.name, null));
            field_22787.method_1507(new StationScreen(blockEntity, station));
            for (Carriage carriage : train.carriages)
                carriage.updateConductors();
        }
    }

    private void tickTrainDisplay() {
        if (getImminent() == null) {
            displayedTrain = new WeakReference<>(null);
            quitAssembly.field_22763 = true;
            iconTypeScroll.field_22763 = iconTypeScroll.field_22764 = false;
            toggleAssemblyButton.setToolTip(CreateLang.translateDirect("station.assemble_train"));
            toggleAssemblyButton.setIcon(AllGuiTextures.I_ASSEMBLE_TRAIN);
            toggleAssemblyButton.withCallback(() -> {
                field_22787.field_1724.field_3944.method_52787(StationEditPacket.tryAssemble(blockEntity.method_11016()));
            });
        } else {
            field_22787.field_1724.field_3944.method_52787(StationEditPacket.configure(blockEntity.method_11016(), false, station.name, null));
            field_22787.method_1507(new StationScreen(blockEntity, station));
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = guiLeft;
        int y = guiTop;

        class_5250 header = CreateLang.translateDirect("station.assembly_title");
        graphics.method_51439(field_22793, header, x + background.getWidth() / 2 - field_22793.method_27525(header) / 2, y + 4, 0xFF0E2233, false);

        AssemblyException lastAssemblyException = blockEntity.lastException;
        if (lastAssemblyException != null) {
            class_5250 text = CreateLang.translateDirect("station.failed");
            graphics.method_51439(field_22793, text, x + 97 - field_22793.method_27525(text) / 2, y + 47, 0xFF775B5B, false);
            int offset = 0;
            if (blockEntity.failedCarriageIndex != -1) {
                graphics.method_51439(
                    field_22793,
                    CreateLang.translateDirect("station.carriage_number", blockEntity.failedCarriageIndex),
                    x + 30,
                    y + 67,
                    0xFF7A7A7A,
                    false
                );
                offset += 10;
            }
            graphics.method_51440(field_22793, lastAssemblyException.component, x + 30, y + 67 + offset, 134, 0xFF775B5B, false);
            offset += field_22793.method_1728(lastAssemblyException.component, 134).size() * 9 + 5;
            graphics.method_51440(field_22793, CreateLang.translateDirect("station.retry"), x + 30, y + 67 + offset, 134, 0xFF7A7A7A, false);
            return;
        }

        int bogeyCount = blockEntity.bogeyCount;

        class_5250 text = CreateLang.translateDirect(
            bogeyCount == 0 ? "station.no_bogeys" : bogeyCount == 1 ? "station.one_bogey" : "station.more_bogeys",
            bogeyCount
        );
        graphics.method_51439(field_22793, text, x + 97 - field_22793.method_27525(text) / 2, y + 47, 0xFF7A7A7A, false);

        graphics.method_51440(field_22793, CreateLang.translateDirect("station.how_to"), x + 28, y + 62, 134, 0xFF7A7A7A, false);
        graphics.method_51440(field_22793, CreateLang.translateDirect("station.how_to_1"), x + 28, y + 94, 134, 0xFF7A7A7A, false);
        graphics.method_51440(field_22793, CreateLang.translateDirect("station.how_to_2"), x + 28, y + 117, 138, 0xFF7A7A7A, false);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        Train train = displayedTrain.get();
        if (train != null) {
            class_2960 iconId = iconTypes.get(iconTypeScroll.getState());
            train.icon = TrainIconType.byId(iconId);
            field_22787.field_1724.field_3944.method_52787(new TrainEditPacket(train.id, "", iconId, train.mapColorIndex));
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return AllPartialModels.STATION_ASSEMBLE;
    }

}
