package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Affine;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public interface TrackBlockRenderer {
    <Self extends Affine<Self>> PartialModel prepareTrackOverlay(
        Affine<Self> affine,
        class_1922 world,
        class_2338 pos,
        class_2680 state,
        BezierTrackPointLocation bezierPoint,
        class_2352 direction,
        RenderedTrackOverlayType type
    );

    PartialModel prepareAssemblyOverlay(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction, class_4587 ms);

    default void render(
        class_1936 level,
        class_2680 trackState,
        class_2338 pos,
        class_2352 direction,
        BezierTrackPointLocation bezier,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay,
        RenderedTrackOverlayType type,
        float scale
    ) {
        if (level instanceof SchematicLevel && !(level instanceof PonderLevel))
            return;

        ms.method_22903();
        var msr = TransformStack.of(ms);
        PartialModel partial = prepareTrackOverlay(msr, level, pos, trackState, bezier, direction, type);
        if (partial != null)
            CachedBuffers.partial(partial, trackState).translate(.5, 0, .5).scale(scale).translate(-.5, 0, -.5)
                .light(class_761.method_23794(level, pos)).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
        ms.method_22909();
    }
}
