package com.zurrtum.create.client.foundation.blockEntity.behaviour;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3965;
import net.minecraft.class_746;

public class ValueSettingsInputHandler {
    public static class_1269 onBlockActivated(class_1937 world, class_746 player, class_1268 hand, class_3965 ray) {
        if (!canInteract(player))
            return null;
        class_1799 stack = player.method_6047();
        if (stack.method_31574(AllItems.CLIPBOARD))
            return null;
        class_2338 pos = ray.method_17777();
        if (!(world.method_8321(pos) instanceof SmartBlockEntity sbe))
            return null;

        if (Create.VALUE_SETTINGS_HANDLER.cancelIfWarmupAlreadyStarted(pos)) {
            return class_1269.field_5814;
        }

        if (sbe instanceof FactoryPanelBlockEntity fpbe) {
            for (FilteringBehaviour<?> behaviour : FactoryPanelBehaviour.allBehaviours(fpbe)) {
                class_1269 result = handleInteraction(behaviour, behaviour.getType(), player, hand, ray, stack, pos, sbe);
                if (result != null) {
                    return result;
                }
            }
        } else {
            ScrollValueBehaviour<?, ?> scrollValueBehaviour = sbe.getBehaviour(ScrollValueBehaviour.TYPE);
            if (scrollValueBehaviour != null) {
                class_1269 result = handleInteraction(scrollValueBehaviour, ScrollValueBehaviour.TYPE, player, hand, ray, stack, pos, sbe);
                if (result != null) {
                    return result;
                }
            }
            FilteringBehaviour<?> filteringBehaviour = sbe.getBehaviour(FilteringBehaviour.TYPE);
            if (filteringBehaviour instanceof SidedFilteringBehaviour sidedBehaviour) {
                filteringBehaviour = sidedBehaviour.get(ray.method_17780());
            }
            if (filteringBehaviour != null) {
                return handleInteraction(filteringBehaviour, FilteringBehaviour.TYPE, player, hand, ray, stack, pos, sbe);
            }
        }
        return null;
    }

    private static class_1269 handleInteraction(
        BlockEntityBehaviour<?> behaviour,
        BehaviourType<? extends BlockEntityBehaviour<?>> type,
        class_746 player,
        class_1268 hand,
        class_3965 ray,
        class_1799 stack,
        class_2338 pos,
        SmartBlockEntity sbe
    ) {
        ValueSettingsBehaviour valueSettingsBehaviour = (ValueSettingsBehaviour) behaviour;
        if (valueSettingsBehaviour.bypassesInput(stack))
            return null;
        if (!valueSettingsBehaviour.mayInteract(player))
            return null;

        if (!valueSettingsBehaviour.isActive())
            return null;
        if (valueSettingsBehaviour.onlyVisibleWithWrench() && !player.method_5998(hand).method_41409().method_40220(AllItemTags.TOOLS_WRENCH))
            return null;
        if (valueSettingsBehaviour.getSlotPositioning() instanceof ValueBoxTransform.Sided sidedSlot) {
            if (!sidedSlot.isSideActive(sbe.method_11010(), ray.method_17780()))
                return null;
            sidedSlot.fromSide(ray.method_17780());
        }

        boolean fakePlayer = FakePlayerHandler.has(player);
        if (!valueSettingsBehaviour.testHit(ray.method_17784()))
            return null;

        if (!valueSettingsBehaviour.acceptsValueSettings() || fakePlayer) {
            valueSettingsBehaviour.onShortInteract(player, hand, ray.method_17780(), ray);
            player.field_3944.method_52787(new ValueSettingsPacket(pos, 0, 0, hand, ray, ray.method_17780(), false, valueSettingsBehaviour.netId()));
            return class_1269.field_5812;
        }

        Create.VALUE_SETTINGS_HANDLER.startInteractionWith(pos, type, hand, ray.method_17780());
        return class_1269.field_5812;
    }

    public static boolean canInteract(class_1657 player) {
        return player != null && !player.method_7325() && !player.method_5715() && player.method_7294();
    }
}
