package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class DeployerRenderer extends class_11239<DeployerRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public DeployerRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    public void render(DeployerRenderState item, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = 26 * windowScaleFactor;
        int height = 75 * windowScaleFactor;
        GpuTexture texture = TEXTURES.get(item.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(item.id(), texture);
        }
        RenderSystem.setProjectionMatrix(field_60042.method_71092(width, height), class_10366.field_54954);
        texture.prepare();
        matrices.method_22903();
        matrices.method_46416(width / 2.0F, height, 0.0F);
        float scale = 20 * windowScaleFactor;
        matrices.method_22905(scale, scale, scale);

        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.5f, -2.24f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.getBuffer(class_4722.method_24074());
        float time = AnimationTickHolder.getRenderTime();
        float cycle = (time - item.offset() * 8) % 30;
        float offset = cycle < 10 ? cycle / 10f : cycle < 20 ? (20 - cycle) / 10f : 0;

        matrices.method_22903();
        blockState = AllBlocks.SHAFT.method_9564().method_11657(class_2741.field_12496, class_2350.class_2351.field_11051);
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(getCurrentAngle(time)));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        blockState = AllBlocks.DEPLOYER.method_9564().method_11657(DeployerBlock.FACING, class_2350.field_11033)
            .method_11657(DeployerBlock.AXIS_ALONG_FIRST_COORDINATE, false);
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        matrices.method_22903();
        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.DEPLOYER_POLE.get(), AllPartialModels.DEPLOYER_HAND_HOLDING.get());
        matrices.method_46416(0, -offset, 0);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_46416(0, -2.06f, 0);
        blockState = AllBlocks.DEPOT.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        field_59933.method_22993();
        matrices.method_22909();
        texture.clear();
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            item.method_72127(),
            item.comp_4122(),
            item.comp_4123(),
            item.comp_4124(),
            item.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            null,
            null
        ));
    }

    public static float getCurrentAngle(float time) {
        return (time * 4f) % 360;
    }

    @Override
    protected void render(DeployerRenderState state, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Deployer";
    }

    @Override
    public Class<DeployerRenderState> method_70903() {
        return DeployerRenderState.class;
    }
}
