package com.zurrtum.create.client.foundation.virtualWorld;

import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.shorts.ShortList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3449;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_6754;
import net.minecraft.class_6763;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class VirtualChunk extends class_2791 {
    public final VirtualRenderWorld world;

    private final VirtualChunkSection[] sections;

    private boolean needsLight;

    public VirtualChunk(VirtualRenderWorld world, int x, int z) {
        super(new class_1923(x, z), class_2843.field_12950, world, world.method_30349().method_30530(class_7924.field_41236), 0L, null, null);

        this.world = world;

        int sectionCount = world.method_32890();
        this.sections = new VirtualChunkSection[sectionCount];

        for (int i = 0, bottom = world.method_32891(); i < sectionCount; i++) {
            sections[i] = new VirtualChunkSection(this, (i + bottom) << 4);
        }

        this.needsLight = true;

        //TODO
        //		Mods.STARLIGHT.executeIfInstalled(() -> () -> {
        //			((ExtendedChunk) this).setBlockNibbles(StarLightEngine.getFilledEmptyLight(this));
        //			((ExtendedChunk) this).setSkyNibbles(StarLightEngine.getFilledEmptyLight(this));
        //		});
    }

    @Override
    @Nullable
    public class_2680 method_12010(class_2338 pos, class_2680 state, int flags) {
        return null;
    }

    @Override
    public void method_12007(class_2586 blockEntity) {
    }

    @Override
    public void method_12002(class_1297 entity) {
    }

    @Override
    public Set<class_2338> method_12021() {
        return Collections.emptySet();
    }

    @Override
    public class_2826[] method_12006() {
        return sections;
    }

    @Override
    public Collection<Map.Entry<class_2902.class_2903, class_2902>> method_12011() {
        return Collections.emptySet();
    }

    @Override
    public void method_12037(class_2902.class_2903 type, long[] data) {
    }

    @Override
    public class_2902 method_12032(class_2902.class_2903 type) {
        return null;
    }

    @Override
    public int method_12005(class_2902.class_2903 type, int x, int z) {
        return 0;
    }

    @Override
    @Nullable
    public class_3449 method_12181(class_3195 structure) {
        return null;
    }

    @Override
    public void method_12184(class_3195 structure, class_3449 structureStart) {
    }

    @Override
    public Map<class_3195, class_3449> method_12016() {
        return Collections.emptyMap();
    }

    @Override
    public void method_12034(Map<class_3195, class_3449> structureStarts) {
    }

    @Override
    public LongSet method_12180(class_3195 pStructure) {
        return LongSets.emptySet();
    }

    @Override
    public void method_12182(class_3195 structure, long reference) {
    }

    @Override
    public Map<class_3195, LongSet> method_12179() {
        return Collections.emptyMap();
    }

    @Override
    public void method_12183(Map<class_3195, LongSet> structureReferencesMap) {
    }

    @Override
    public void method_65063() {
    }

    @Override
    public boolean method_12044() {
        return false;
    }

    @Override
    public class_2806 method_12009() {
        return class_2806.field_12805;
    }

    @Override
    public void method_12041(class_2338 pos) {
    }

    @Override
    public ShortList[] method_12012() {
        return new ShortList[0];
    }

    @Override
    @Nullable
    public class_2487 method_12024(class_2338 pos) {
        return null;
    }

    @Override
    @Nullable
    public class_2487 method_20598(class_2338 pos, class_7225.class_7874 registries) {
        return null;
    }

    @Override
    public void method_51525(@NotNull Predicate<class_2680> roughFilter, @NotNull BiConsumer<class_2338, class_2680> output) {
        world.blockStates.forEach((blockPos, state) -> {
            if (class_4076.method_18675(blockPos.method_10263()) == field_34538.field_9181 && class_4076.method_18675(blockPos.method_10260()) == field_34538.field_9180) {
                if (roughFilter.test(state)) {
                    output.accept(blockPos, state);
                }
            }
        });
    }

    @Override
    public class_6763<class_2248> method_12013() {
        return class_6754.method_39361();
    }

    @Override
    public class_6763<class_3611> method_12014() {
        return class_6754.method_39361();
    }

    @Override
    public class_6745 method_39296(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long method_12033() {
        return 0;
    }

    @Override
    public void method_12028(long amount) {
    }

    @Override
    public boolean method_12038() {
        return needsLight;
    }

    @Override
    public void method_12020(boolean lightCorrect) {
        this.needsLight = lightCorrect;
    }

    @Override
    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        return world.method_8321(pos);
    }

    @Override
    public class_2680 method_8320(class_2338 pos) {
        return world.method_8320(pos);
    }

    @Override
    public class_3610 method_8316(class_2338 pos) {
        return world.method_8316(pos);
    }
}
