package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_811;
import net.minecraft.client.render.model.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.List;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class ClipboardModel implements class_10439 {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/clipboard");
    public static final class_2960 EMPTY_ID = class_2960.method_60655(MOD_ID, "item/clipboard_0");
    public static final class_2960 WRITTEN_ID = class_2960.method_60655(MOD_ID, "item/clipboard_1");
    public static final class_2960 EDITING_ID = class_2960.method_60655(MOD_ID, "item/clipboard_2");
    private final class_1921 layer = class_4722.method_29382();
    private final ModelData[] models;

    public ClipboardModel(ModelData[] models) {
        this.models = models;
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_1309 user,
        int seed
    ) {
        int index = stack.method_58695(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY).type().ordinal();
        state.method_70946(this);
        state.method_70946(index);
        models[index].update(state, layer, displayContext);

    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        @Override
        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(EMPTY_ID);
            resolver.markDependency(WRITTEN_ID);
            resolver.markDependency(EDITING_ID);
        }

        @Override
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            ModelData[] models = new ModelData[3];
            models[0] = ModelData.bake(baker, EMPTY_ID);
            models[1] = ModelData.bake(baker, WRITTEN_ID);
            models[2] = ModelData.bake(baker, EDITING_ID);
            return new ClipboardModel(models);
        }
    }

    public record ModelData(List<class_777> quads, class_10809 settings, Supplier<Vector3f[]> vector) {
        public static ModelData bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_5350).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new ModelData(quads, settings, Suppliers.memoize(() -> class_10430.method_67990(quads)));
        }

        public void update(class_10444 state, class_1921 layer, class_811 displayContext) {
            class_10444.class_10446 layerRenderState = state.method_65601();
            layerRenderState.method_67992(layer);
            layerRenderState.method_67995(vector);
            settings.method_68000(layerRenderState, displayContext);
            layerRenderState.method_67997().addAll(quads);
        }
    }
}
