package com.zurrtum.create.client.ponder.foundation.registration;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.registration.SceneRegistryAccess;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import org.jetbrains.annotations.Nullable;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_638;
import net.minecraft.class_7923;

public class PonderSceneRegistry implements SceneRegistryAccess {

    private final PonderLocalization localization;
    private final Multimap<class_2960, StoryBoardEntry> scenes;

    private boolean allowRegistration = true;

    public PonderSceneRegistry(PonderLocalization localization) {
        this.localization = localization;
        scenes = LinkedHashMultimap.create();
    }

    public void clearRegistry() {
        scenes.clear();
        allowRegistration = true;
    }

    //

    public void addStoryBoard(StoryBoardEntry entry) {
        if (!allowRegistration)
            throw new IllegalStateException("Registration Phase has already ended!");

        scenes.put(entry.getComponent(), entry);
    }

    //

    @Override
    public Collection<Map.Entry<class_2960, StoryBoardEntry>> getRegisteredEntries() {
        return scenes.entries();
    }

    @Override
    public boolean doScenesExistForId(class_2960 id) {
        return scenes.containsKey(id);
    }

    //

    @Override
    public List<PonderScene> compile(class_2960 id) {
        if (PonderIndex.editingModeActive())
            PonderIndex.reload();

        Collection<StoryBoardEntry> entries = scenes.get(id);

        if (entries.isEmpty())
            return Collections.emptyList();

        return compile(entries);

    }

    @Override
    public List<PonderScene> compile(Collection<StoryBoardEntry> entries) {
        if (PonderIndex.editingModeActive()) {
            localization.clearShared();
            PonderIndex.gatherSharedText();
        }

        List<PonderScene> scenes = new ArrayList<>();

        class_638 world = class_310.method_1551().field_1687;
        for (StoryBoardEntry storyBoard : entries) {
            class_3499 activeTemplate = loadSchematic(storyBoard.getSchematicLocation());
            PonderLevel level = new PonderLevel(class_2338.field_10980, world);
            activeTemplate.method_15172(level, class_2338.field_10980, class_2338.field_10980, new class_3492(), level.field_9229, class_2248.field_31028);
            level.createBackup();
            PonderScene scene = compileScene(localization, storyBoard, level);
            scene.begin();
            scenes.add(scene);
        }

        return scenes;
    }

    public static PonderScene compileScene(PonderLocalization localization, StoryBoardEntry sb, @Nullable PonderLevel level) {
        PonderScene scene = new PonderScene(level, localization, sb.getNamespace(), sb.getComponent(), sb.getTags(), sb.getOrderingEntries());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static class_3499 loadSchematic(class_2960 location) {
        return loadSchematic(class_310.method_1551().method_1478(), location);
    }

    public static class_3499 loadSchematic(class_3300 resourceManager, class_2960 location) {
        String namespace = location.method_12836();
        String path = "ponder/" + location.method_12832() + ".nbt";
        class_2960 location1 = class_2960.method_60655(namespace, path);

        Optional<class_3298> optionalResource = resourceManager.method_14486(location1);
        if (optionalResource.isEmpty()) {
            Ponder.LOGGER.error("Ponder schematic missing: " + location1);

            return new class_3499();
        }

        class_3298 resource = optionalResource.get();
        try (InputStream inputStream = resource.method_14482()) {
            return loadSchematic(inputStream);
        } catch (IOException e) {
            Ponder.LOGGER.error("Failed to read ponder schematic: " + location1, e);
        }

        return new class_3499();
    }

    public static class_3499 loadSchematic(InputStream resourceStream) throws IOException {
        class_3499 t = new class_3499();
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));
        class_2487 nbt = class_2507.method_10625(stream, class_2505.method_53899(0x20000000L));
        //t.load(Minecraft.getInstance().level.holderLookup(Registries.BLOCK), nbt);
        t.method_15183(class_7923.field_41175, nbt);
        return t;
    }
}