package com.zurrtum.create.client.ponder.foundation.registration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.registration.TagRegistryAccess;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

public class PonderTagRegistry implements TagRegistryAccess {

    private final PonderLocalization localization;
    private final Multimap<class_2960, class_2960> componentTagMap;
    private final Map<class_2960, PonderTag> registeredTags;
    private final List<PonderTag> listedTags;

    private final PonderTag MISSING = new PonderTag(
        Ponder.asResource("not_registered"),
        null,
        class_1802.field_8077.method_7854(),
        class_1802.field_8077.method_7854()
    );

    private boolean allowRegistration = true;

    public PonderTagRegistry(PonderLocalization localization) {
        this.localization = localization;
        componentTagMap = LinkedHashMultimap.create();
        registeredTags = new HashMap<>();
        listedTags = new ArrayList<>();
    }

    public void clearRegistry() {
        componentTagMap.clear();
        listedTags.clear();
        allowRegistration = true;
    }

    //

    public void registerTag(PonderTag tag) {
        if (!allowRegistration)
            throw new IllegalStateException("Registration Phase has already ended!");

        registeredTags.put(tag.getId(), tag);
    }

    public void listTag(PonderTag tag) {
        if (!allowRegistration)
            throw new IllegalStateException("Registration Phase has already ended!");

        listedTags.add(tag);
    }

    public void addTagToComponent(class_2960 tag, class_2960 item) {
        if (!allowRegistration)
            throw new IllegalStateException("Registration Phase has already ended!");

        synchronized (componentTagMap) {
            componentTagMap.put(item, tag);
        }
    }

    //

    @Override
    public PonderTag getRegisteredTag(class_2960 tagLocation) {
        return registeredTags.getOrDefault(tagLocation, MISSING);
    }

    @Override
    public List<PonderTag> getListedTags() {
        return listedTags;
    }

    @Override
    public Set<PonderTag> getTags(class_2960 item) {
        return componentTagMap.get(item).stream().map(this::getRegisteredTag).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<class_2960> getItems(class_2960 tag) {
        return componentTagMap.entries().stream().filter(e -> e.getValue().equals(tag)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<class_2960> getItems(PonderTag tag) {
        return getItems(tag.getId());
    }

}