package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.foundation.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_8235;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class StickerBlock extends WrenchableDirectionalBlock implements IBE<StickerBlockEntity>, WeakPowerControlBlock, LandingEffectControlBlock, RunningEffectControlBlock {

    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 EXTENDED = class_2741.field_12552;

    public StickerBlock(class_2251 p_i48415_1_) {
        super(p_i48415_1_);
        method_9590(method_9564().method_11657(POWERED, false).method_11657(EXTENDED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 nearestLookingDirection = context.method_7715();
        boolean shouldPower = context.method_8045().method_49803(context.method_8037());
        class_2350 facing = context.method_8036() != null && context.method_8036()
            .method_5715() ? nearestLookingDirection : nearestLookingDirection.method_10153();

        return method_9564().method_11657(field_10927, facing).method_11657(POWERED, shouldPower);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(POWERED, EXTENDED));
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (worldIn.field_9236)
            return;

        boolean previouslyPowered = state.method_11654(POWERED);
        if (previouslyPowered != worldIn.method_49803(pos)) {
            state = state.method_28493(POWERED);
            if (state.method_11654(POWERED))
                state = state.method_28493(EXTENDED);
            worldIn.method_8652(pos, state, class_2248.field_31028);
        }
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    @Override
    public Class<StickerBlockEntity> getBlockEntityClass() {
        return StickerBlockEntity.class;
    }

    @Override
    public class_2591<? extends StickerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.STICKER;
    }

    // Slime block stuff

    private boolean isUprightSticker(class_1922 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_27852(AllBlocks.STICKER) && blockState.method_11654(field_10927) == class_2350.field_11036;
    }

    @Override
    public void method_9554(class_1937 p_152426_, class_2680 p_152427_, class_2338 p_152428_, class_1297 p_152429_, double p_152430_) {
        if (!isUprightSticker(p_152426_, p_152428_) || p_152429_.method_21750())
            super.method_9554(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        p_152429_.method_5747(p_152430_, 1.0F, p_152426_.method_48963().method_48827());
    }

    @Override
    public void method_9502(class_1922 p_176216_1_, class_1297 p_176216_2_) {
        if (!isUprightSticker(p_176216_1_, p_176216_2_.method_24515().method_10074()) || p_176216_2_.method_21750()) {
            super.method_9502(p_176216_1_, p_176216_2_);
        } else {
            this.bounceUp(p_176216_2_);
        }
    }

    private void bounceUp(class_1297 p_226946_1_) {
        class_243 Vector3d = p_226946_1_.method_18798();
        if (Vector3d.field_1351 < 0.0D) {
            double d0 = p_226946_1_ instanceof class_1309 ? 1.0D : 0.8D;
            p_226946_1_.method_18800(Vector3d.field_1352, -Vector3d.field_1351 * d0, Vector3d.field_1350);
        }
    }

    @Override
    public void method_9591(class_1937 p_152431_, class_2338 p_152432_, class_2680 p_152433_, class_1297 p_152434_) {
        double d0 = Math.abs(p_152434_.method_18798().field_1351);
        if (d0 < 0.1D && !p_152434_.method_21749() && isUprightSticker(p_152431_, p_152432_)) {
            double d1 = 0.4D + d0 * 0.2D;
            p_152434_.method_18799(p_152434_.method_18798().method_18805(d1, 1.0D, d1));
        }
        super.method_9591(p_152431_, p_152432_, p_152433_, p_152434_);
    }

    @Override
    public boolean addLandingEffects(class_2680 state, class_3218 world, class_2338 pos, class_1309 entity, double distance) {
        if (state.method_11654(field_10927) == class_2350.field_11036) {
            double e = entity.method_23317();
            double f = entity.method_23318();
            double g = entity.method_23321();
            class_2338 blockPos = entity.method_24515();
            if (pos.method_10263() != blockPos.method_10263() || pos.method_10260() != blockPos.method_10260()) {
                double h = e - pos.method_10263() - 0.5;
                double i = g - pos.method_10260() - 0.5;
                double j = Math.max(Math.abs(h), Math.abs(i));
                e = pos.method_10263() + 0.5 + h / j * 0.5;
                g = pos.method_10260() + 0.5 + i / j * 0.5;
            }

            double h = Math.min(0.2F + distance / 15.0, 2.5);
            int k = (int) (150.0 * h);
            world.method_65096(
                new class_2388(class_2398.field_11217, class_2246.field_10030.method_9564()),
                e,
                f,
                g,
                k,
                0.0D,
                0.0D,
                0.0D,
                0.15F
            );
        }
        return false;
    }

    @Override
    public boolean addRunningEffects(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (state.method_11654(field_10927) == class_2350.field_11036) {
            class_243 vec3d = entity.method_18798();
            class_2338 blockPos = entity.method_24515();
            double d = entity.method_23317() + (entity.method_59922().method_43058() - 0.5) * entity.method_17681();
            double e = entity.method_23321() + (entity.method_59922().method_43058() - 0.5) * entity.method_17681();
            int x = pos.method_10263();
            if (blockPos.method_10263() != x) {
                d = class_3532.method_15350(d, x, x + 1.0);
            }

            int z = pos.method_10260();
            if (blockPos.method_10260() != z) {
                e = class_3532.method_15350(e, z, z + 1.0);
            }
            world.method_8406(
                new class_2388(class_2398.field_11217, class_2246.field_10030.method_9564()),
                d,
                entity.method_23318() + 0.1,
                e,
                vec3d.field_1352 * -4.0,
                1.5,
                vec3d.field_1350 * -4.0
            );
            return true;
        }
        return false;
    }

}
