package com.zurrtum.create.content.equipment.symmetryWand;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.SymmetryEffectPacket;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_6088;

public class SymmetryWandItem extends class_1792 {

    public SymmetryWandItem(class_1793 properties) {
        super(properties);
    }

    @NotNull
    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        if (player == null)
            return class_1269.field_5811;
        class_1799 wand = player.method_5998(context.method_20287());
        player.method_7357().method_62835(wand, 5);
        checkComponents(wand);

        // Shift -> open GUI
        if (player.method_5715()) {
            if (player.method_37908().field_9236) {
                AllClientHandle.INSTANCE.openSymmetryWandScreen(wand, context.method_20287());
            }
            return class_1269.field_5812;
        }

        if (context.method_8045().field_9236 || context.method_20287() != class_1268.field_5808)
            return class_1269.field_5812;

        pos = pos.method_10093(context.method_8038());
        SymmetryMirror previousElement = wand.method_58694(AllDataComponents.SYMMETRY_WAND);

        // No Shift -> Make / Move Mirror
        wand.method_57379(AllDataComponents.SYMMETRY_WAND_ENABLE, true);
        class_243 pos3d = new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260());
        SymmetryMirror newElement = new PlaneMirror(pos3d);

        if (previousElement instanceof EmptyMirror) {
            newElement.setOrientation((player.method_5735() == class_2350.field_11043 || player.method_5735() == class_2350.field_11035) ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            newElement.enable = true;
            wand.method_57379(AllDataComponents.SYMMETRY_WAND_ENABLE, true);
        } else {
            previousElement.setPosition(pos3d);

            if (previousElement instanceof PlaneMirror) {
                previousElement.setOrientation((player.method_5735() == class_2350.field_11043 || player.method_5735() == class_2350.field_11035) ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            }

            if (previousElement instanceof CrossPlaneMirror) {
                float rotation = player.method_5791();
                float abs = Math.abs(rotation % 90);
                boolean diagonal = abs > 22 && abs < 45 + 22;
                previousElement.setOrientation(diagonal ? CrossPlaneMirror.Align.D.ordinal() : CrossPlaneMirror.Align.Y.ordinal());
            }

            newElement = previousElement;
        }

        wand.method_57379(AllDataComponents.SYMMETRY_WAND, newElement);

        player.method_6122(context.method_20287(), wand);
        return class_1269.field_5812;
    }

    @Override
    public class_1269 method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 wand = playerIn.method_5998(handIn);
        checkComponents(wand);

        // Shift -> Open GUI
        if (playerIn.method_5715()) {
            if (worldIn.field_9236) {
                AllClientHandle.INSTANCE.openSymmetryWandScreen(wand, handIn);
                playerIn.method_7357().method_62835(wand, 5);
            }
            return class_1269.field_5812;
        }

        // No Shift -> Clear Mirror
        wand.method_57379(AllDataComponents.SYMMETRY_WAND_ENABLE, false);
        return class_1269.field_5812.method_61393(wand);
    }

    private static void checkComponents(class_1799 wand) {
        if (!wand.method_57826(AllDataComponents.SYMMETRY_WAND)) {
            wand.method_57379(AllDataComponents.SYMMETRY_WAND, new EmptyMirror(new class_243(0, 0, 0)));
            wand.method_57379(AllDataComponents.SYMMETRY_WAND_ENABLE, false);
        }
    }

    public static boolean isEnabled(class_1799 stack) {
        checkComponents(stack);
        return stack.method_58695(AllDataComponents.SYMMETRY_WAND_ENABLE, false) && !stack.method_58695(
            AllDataComponents.SYMMETRY_WAND_SIMULATE,
            false
        );
    }

    public static SymmetryMirror getMirror(class_1799 stack) {
        checkComponents(stack);
        return stack.method_58694(AllDataComponents.SYMMETRY_WAND);
    }

    public static void configureSettings(class_1799 stack, SymmetryMirror mirror) {
        checkComponents(stack);
        stack.method_57379(AllDataComponents.SYMMETRY_WAND, mirror);
    }

    public static void apply(
        class_3218 world,
        class_1799 wand,
        class_1657 player,
        class_2338 pos,
        class_2680 block,
        class_243 hitPos,
        boolean canReplaceExisting,
        class_2350 side,
        class_1268 hand
    ) {
        checkComponents(wand);
        if (!isEnabled(wand))
            return;
        if (!class_1747.field_8003.containsKey(block.method_26204()))
            return;

        Map<class_2338, Pair<class_2350, class_2680>> blockSet = new HashMap<>();
        blockSet.put(pos, Pair.of(side, block));
        SymmetryMirror symmetry = wand.method_58694(AllDataComponents.SYMMETRY_WAND);

        class_243 mirrorPos = symmetry.getPosition();
        if (mirrorPos.method_1022(class_243.method_24954(pos)) > AllConfigs.server().equipment.maxSymmetryWandRange.get())
            return;

        symmetry.process(blockSet);
        class_2338 to = class_2338.method_49638(mirrorPos);
        List<class_2338> targets = new ArrayList<>();
        targets.add(pos);

        double y = hitPos.method_10214();
        for (class_2338 position : blockSet.keySet()) {
            if (position.equals(pos))
                continue;

            if (world.method_8628(block, position, class_3726.method_16195(player))) {
                Pair<class_2350, class_2680> pair = blockSet.get(position);
                class_2350 direction = pair.getFirst();
                class_2680 blockState = pair.getSecond();
                for (class_2350 face : Iterate.directions)
                    blockState = blockState.method_26191(
                        world,
                        world,
                        position,
                        face,
                        position.method_10093(face),
                        world.method_8320(position.method_10093(face)),
                        world.field_9229
                    );

                if (player.method_68878()) {
                    world.method_8501(position, blockState);
                    targets.add(position);
                    continue;
                }

                class_2680 toReplace = world.method_8320(position);
                if (toReplace.method_26214(world, position) == -1)
                    continue;

                class_1799 current;
                List<Runnable> tasks;
                if (blockState.method_27852(AllBlocks.CART_ASSEMBLER)) {
                    class_2680 railBlock = CartAssemblerBlock.getRailBlock(blockState);
                    Pair<class_1799, List<Runnable>> findRail = BlockHelper.findInInventory(toReplace, railBlock, player);
                    class_1799 rail = findRail.getFirst();
                    if (rail.method_7960()) {
                        continue;
                    }
                    tasks = findRail.getSecond();
                    Pair<class_1799, List<Runnable>> findBlock = BlockHelper.findInInventory(toReplace, blockState, player);
                    class_1799 cartAssembler = findBlock.getFirst();
                    if (cartAssembler.method_7960()) {
                        current = rail;
                    } else {
                        tasks.addAll(findBlock.getSecond());
                        current = cartAssembler;
                    }
                } else {
                    Pair<class_1799, List<Runnable>> find = BlockHelper.findInInventory(toReplace, blockState, player);
                    current = find.getFirst();
                    if (current.method_7960()) {
                        continue;
                    }
                    tasks = find.getSecond();
                }

                SymmetryPlacementContext placementContext = new SymmetryPlacementContext(
                    world,
                    player,
                    hand,
                    current,
                    position,
                    direction,
                    y,
                    canReplaceExisting,
                    toReplace,
                    blockState
                );
                if (!(toReplace.method_45474() || toReplace.method_26166(placementContext)))
                    continue;

                wand.method_57379(AllDataComponents.SYMMETRY_WAND_SIMULATE, true);
                class_1269 actionResult = class_1269.field_5814;
                int count = 0;
                for (int size = current.method_7947(); count < size; count++) {
                    actionResult = current.method_7981(placementContext);
                    if (!actionResult.method_23665()) {
                        break;
                    }
                }
                wand.method_57379(AllDataComponents.SYMMETRY_WAND_SIMULATE, false);
                if (actionResult.method_23665()) {
                    targets.add(position);
                    tasks.forEach(Runnable::run);
                } else if (count != 0) {
                    targets.add(position);
                    tasks.forEach(Runnable::run);
                    player.method_31548().method_7398(placementContext.method_8041());
                }
            }
        }

        world.method_14178().method_18751(player, new SymmetryEffectPacket(to, targets));
    }

    private static boolean isHoldingBlock(class_1657 player, class_2680 block) {
        class_1799 itemBlock = BlockHelper.getRequiredItem(block);
        return player.method_24518(itemBlock.method_7909());
    }

    public static void remove(class_3218 world, class_1799 wand, class_1657 player, class_2338 pos, class_2680 ogBlock) {
        class_2680 air = class_2246.field_10124.method_9564();
        checkComponents(wand);
        if (!isEnabled(wand))
            return;

        Set<class_2338> positions = new HashSet<>();
        positions.add(pos);
        SymmetryMirror symmetry = wand.method_58694(AllDataComponents.SYMMETRY_WAND);

        class_243 mirrorPos = symmetry.getPosition();
        if (mirrorPos.method_1022(class_243.method_24954(pos)) > AllConfigs.server().equipment.maxSymmetryWandRange.get())
            return;

        symmetry.process(positions);

        class_2338 to = class_2338.method_49638(mirrorPos);
        List<class_2338> targets = new ArrayList<>();

        targets.add(pos);
        boolean noCreative = !player.method_68878();
        for (class_2338 position : positions) {
            if (noCreative && ogBlock.method_26204() != world.method_8320(position).method_26204())
                continue;
            if (position.equals(pos))
                continue;

            class_2680 blockstate = world.method_8320(position);
            if (!blockstate.method_26215()) {
                targets.add(position);
                world.method_20290(class_6088.field_31144, position, class_2248.method_9507(blockstate));
                world.method_8652(position, air, class_2248.field_31036);

                if (noCreative) {
                    class_1799 stack = player.method_6047();
                    if (!stack.method_7960())
                        stack.method_7952(world, blockstate, position, player);
                    class_2586 blockEntity = blockstate.method_31709() ? world.method_8321(position) : null;
                    class_2248.method_9511(blockstate, world, pos, blockEntity, player, stack); // Add fortune, silk touch and other loot modifiers
                }
            }
        }

        world.method_14178().method_18751(player, new SymmetryEffectPacket(to, targets));
    }

    public static boolean presentInHotbar(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (int i = 0, size = class_1661.method_7368(); i < size; i++)
            if (inv.method_5438(i).method_31574(AllItems.WAND_OF_SYMMETRY))
                return true;
        return false;
    }

}
