package com.zurrtum.create.content.fluids.pipes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.decoration.encasing.EncasableBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchableWithBracket;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

public class FluidPipeBlock extends class_2429 implements class_3737, IWrenchableWithBracket, IBE<FluidPipeBlockEntity>, EncasableBlock, TransformableBlock, NeighborUpdateListeningBlock {

    private static final class_265 OCCLUSION_BOX = class_2248.method_9541(4, 4, 4, 12, 12, 12);

    public static final MapCodec<FluidPipeBlock> field_46280 = method_54094(FluidPipeBlock::new);

    public FluidPipeBlock(class_2251 properties) {
        super(8f, properties);
        method_9590(method_9564().method_11657(class_2741.field_12508, false));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (tryRemoveBracket(context))
            return class_1269.field_5812;

        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 clickedFace = context.method_8038();

        class_2351 axis = getAxis(world, pos, state);
        if (axis == null) {
            class_243 clickLocation = context.method_17698().method_1023(pos.method_10263(), pos.method_10264(), pos.method_10260());
            double closest = Float.MAX_VALUE;
            class_2350 argClosest = class_2350.field_11036;
            for (class_2350 direction : Iterate.directions) {
                if (clickedFace.method_10166() == direction.method_10166())
                    continue;
                class_243 centerOf = class_243.method_24953(direction.method_62675());
                double distance = centerOf.method_1025(clickLocation);
                if (distance < closest) {
                    closest = distance;
                    argClosest = direction;
                }
            }
            axis = argClosest.method_10166();
        }

        if (clickedFace.method_10166() == axis)
            return class_1269.field_5811;
        if (!world.field_9236) {
            withBlockEntityDo(
                world,
                pos,
                fpte -> fpte.getBehaviour(FluidTransportBehaviour.TYPE).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow())
                    .findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.trigger((class_3222) context.method_8036()))
            );

            FluidTransportBehaviour.cacheFlows(world, pos);
            world.method_8501(
                pos,
                AllBlocks.GLASS_FLUID_PIPE.method_9564().method_11657(GlassFluidPipeBlock.field_11459, axis)
                    .method_11657(class_2741.field_12508, state.method_11654(class_2741.field_12508))
            );
            FluidTransportBehaviour.loadFlows(world, pos);
        }
        return class_1269.field_5812;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        class_1269 result = tryEncase(state, level, pos, stack, player, hand, hitResult);
        if (result.method_23665())
            return result;

        return class_1269.field_52423;
    }

    public class_2680 getAxisState(class_2351 axis) {
        class_2680 defaultState = method_9564();
        for (class_2350 d : Iterate.directions)
            defaultState = defaultState.method_11657(field_11329.get(d), d.method_10166() == axis);
        return defaultState;
    }

    @Nullable
    private class_2351 getAxis(class_1922 world, class_2338 pos, class_2680 state) {
        return FluidPropagator.getStraightPipeAxis(state);
    }

    @Override
    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean isMoving) {
        if (!world.field_9236)
            FluidPropagator.propagateChangedPipe(world, pos, state);
        if (!isMoving)
            removeBracket(world, pos, true).ifPresent(stack -> class_2248.method_9577(world, pos, stack));
        if (state.method_31709())
            world.method_8544(pos);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (world.field_9236)
            return;
        if (state != oldState)
            world.method_64311(pos, this, 1, class_1953.field_9310);
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 otherBlock, class_2338 neighborPos, boolean isMoving) {
        class_2350 d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null)
            return;
        if (!isOpenAt(state, d))
            return;
        world.method_64311(pos, this, 1, class_1953.field_9310);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_2248 otherBlock,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        class_4209.method_19472(world, pos);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 r) {
        FluidPropagator.propagateChangedPipe(world, pos, state);
    }

    public static boolean isPipe(class_2680 state) {
        return state.method_26204() instanceof FluidPipeBlock;
    }

    public static boolean canConnectTo(class_1920 world, class_2338 neighbourPos, class_2680 neighbour, class_2350 direction) {
        if (FluidPropagator.hasFluidCapability(world, neighbourPos, direction.method_10153()))
            return true;
        if (VanillaFluidTargets.canProvideFluidWithoutCapability(neighbour))
            return true;
        if (isPipe(neighbour)) {
            BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get(world, neighbourPos, BracketedBlockEntityBehaviour.TYPE);
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis(neighbour) == direction.method_10166();
        }
        FluidTransportBehaviour transport = BlockEntityBehaviour.get(world, neighbourPos, FluidTransportBehaviour.TYPE);
        if (transport == null)
            return false;
        return transport.canHaveFlowToward(neighbour, direction.method_10153());
    }

    public static boolean shouldDrawRim(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2338 offsetPos = pos.method_10093(direction);
        class_2680 facingState = world.method_8320(offsetPos);
        if (facingState.method_26204() instanceof EncasedPipeBlock)
            return true;
        if (!isPipe(facingState))
            return true;
        return !canConnectTo(world, offsetPos, facingState, direction);
    }

    public static boolean isOpenAt(class_2680 state, class_2350 direction) {
        return state.method_11654(field_11329.get(direction));
    }

    public static boolean isCornerOrEndPipe(class_1920 world, class_2338 pos, class_2680 state) {
        return isPipe(state) && FluidPropagator.getStraightPipeAxis(state) == null && !shouldDrawCasing(world, pos, state);
    }

    public static boolean shouldDrawCasing(class_1920 world, class_2338 pos, class_2680 state) {
        if (!isPipe(state))
            return false;
        for (class_2351 axis : Iterate.axes) {
            int connections = 0;
            for (class_2350 direction : Iterate.directions)
                if (direction.method_10166() != axis && isOpenAt(state, direction))
                    connections++;
            if (connections > 2)
                return true;
        }
        return false;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11332, field_11335, field_11331, field_11328, field_11327, field_11330, class_2741.field_12508);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 FluidState = context.method_8045().method_8316(context.method_8037());
        return updateBlockState(
            method_9564(),
            context.method_7715(),
            null,
            context.method_8045(),
            context.method_8037()
        ).method_11657(class_2741.field_12508, Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(class_2741.field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        if (isOpenAt(state, direction) && neighbourState.method_28498(class_2741.field_12508))
            tickView.method_64311(pos, this, 1, class_1953.field_9310);
        return updateBlockState(state, direction, direction.method_10153(), world, pos);
    }

    public class_2680 updateBlockState(
        class_2680 state,
        class_2350 preferredDirection,
        @Nullable class_2350 ignore,
        class_1920 world,
        class_2338 pos
    ) {

        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent())
            return state;

        class_2680 prevState = state;
        int prevStateSides = (int) Arrays.stream(Iterate.directions).map(field_11329::get).filter(prevState::method_11654).count();

        // Update sides that are not ignored
        for (class_2350 d : Iterate.directions)
            if (d != ignore) {
                boolean shouldConnect = canConnectTo(world, pos.method_10093(d), world.method_8320(pos.method_10093(d)), d);
                state = state.method_11657(field_11329.get(d), shouldConnect);
            }

        // See if it has enough connections
        class_2350 connectedDirection = null;
        for (class_2350 d : Iterate.directions) {
            if (isOpenAt(state, d)) {
                if (connectedDirection != null)
                    return state;
                connectedDirection = d;
            }
        }

        // Add opposite end if only one connection
        if (connectedDirection != null)
            return state.method_11657(field_11329.get(connectedDirection.method_10153()), true);

        // If we can't connect to anything and weren't connected before, do nothing
        if (prevStateSides == 2)
            return prevState;

        // Use preferred
        return state.method_11657(field_11329.get(preferredDirection), true).method_11657(field_11329.get(preferredDirection.method_10153()), true);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public Optional<class_1799> removeBracket(class_1922 world, class_2338 pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = BracketedBlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null)
            return Optional.empty();
        class_2680 bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null)
            return Optional.empty();
        return Optional.of(new class_1799(bracket.method_26204()));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    @Override
    public class_2591<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.FLUID_PIPE;
    }

    @Override
    public class_265 method_9571(class_2680 pState) {
        return OCCLUSION_BOX;
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return FluidPipeBlockRotation.rotate(pState, pRotation);
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return FluidPipeBlockRotation.mirror(pState, pMirror);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        return FluidPipeBlockRotation.transform(state, transform);
    }

    @Override
    protected @NotNull MapCodec<? extends class_2429> method_53969() {
        return field_46280;
    }
}
