package com.zurrtum.create.content.kinetics.chainDrive;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ChainGearshiftBlockEntity extends KineticBlockEntity {

    int signal;
    boolean signalChanged;

    public ChainGearshiftBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ADJUSTABLE_CHAIN_GEARSHIFT, pos, state);
        signal = 0;
        setLazyTickRate(40);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Signal", signal);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        signal = view.method_71424("Signal", 0);
        super.read(view, clientPacket);
    }

    public float getModifier() {
        return getModifierForSignal(signal);
    }

    public void neighbourChanged() {
        if (!method_11002())
            return;
        int power = field_11863.method_49804(field_11867);
        if (power != signal)
            signalChanged = true;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        neighbourChanged();
    }

    @Override
    public void tick() {
        super.tick();
        if (field_11863.field_9236)
            return;
        if (signalChanged) {
            signalChanged = false;
            analogSignalChanged(field_11863.method_49804(field_11867));
        }
    }

    protected void analogSignalChanged(int newSignal) {
        detachKinetics();
        removeSource();
        signal = newSignal;
        attachKinetics();
    }

    protected float getModifierForSignal(int newPower) {
        if (newPower == 0)
            return 1;
        return 1 + ((newPower + 1) / 16f);
    }

}
